<?php

declare(strict_types=1);

namespace Drupal\Tests\purge_users\Functional\policy;

use Drupal\Tests\purge_users\Functional\NotLoggedDeleteAnonymizeTestBatchDelete;

/**
 * Purge users who did not log in for a specific period.
 *
 * - Tested with multiple created nodes to trigger the batch delete.
 * - Purge method: delete the account and
 * make its content belong to the Anonymous user.
 * - Disregard inactive/blocked users unselected.
 * - User Deletion Notification unselected.
 *
 * @group purge_users
 */
class PolicyNotLoggedDeleteAnonymizeTestBatchDelete extends NotLoggedDeleteAnonymizeTestBatchDelete {

  /**
   * Setup configuration for the test.
   */
  protected function setUpConfig(): void {
    // Set the basic configuration and add the specific changes.
    $this->setBasicConfig();
    // Set up the test policy configuration.
    $policy = $this->setBasicPolicyConfig();
    $conditions = $policy->getConditions();
    $conditions[] = [
      'id' => 'purge_users:not_logged_in',
      'user_lastlogin_value' => '10',
      'user_lastlogin_period' => 'month',
    ];
    $policy->set('policy_conditions', $conditions);
    $policy->set('purge_user_cancel_method', 'user_cancel_reassign');
    $policy->save();
  }

}
