<?php

declare(strict_types=1);

namespace Drupal\Tests\purge_users\Functional\policy;

use Drupal\purge_users\Entity\PurgeUsersPolicy;
use Drupal\Tests\purge_users\Functional\SettingsFormTest;

/**
 * Tests submission of Purge Users policy form.
 *
 * @group purge_users
 */
class PolicySettingsFormTest extends SettingsFormTest {

  /**
   * A policy entity.
   *
   * @var \Drupal\purge_users\Entity\PurgeUsersPolicy
   */
  protected $policy;

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    // Create a new PurgeUsersPolicy entity instance.
    /** @var \Drupal\purge_users\Entity\PurgeUsersPolicy $policy */
    $this->policy = PurgeUsersPolicy::create([
      'id' => 'test_policy',
      'label' => 'Test Policy',
      'description' => 'A policy for testing purposes.',
      'purge_user_cancel_method' => 'user_cancel_delete',
      'send_email_notification' => 'default',
      'disregard_blocked_users' => FALSE,
      'purge_on_cron' => FALSE,
      'inactive_user_notify_subject' => 'Dear user',
      'inactive_user_notify_text' => 'Dear User, Your account has been deleted due the website’s policy to automatically remove users who match certain criteria. If you have concerns regarding the deletion, please talk to the administrator of the website. Thank you',
      'user_before_deletion_subject' => 'Dear user',
      'send_email_user_before_notification' => 'default',
      'user_before_deletion_text' => 'Dear User, Your account will be deleted soon due the website’s policy to automatically remove users who match certain criteria. If you have concerns regarding the deletion, please talk to the administrator of the website. Thank you',
    ]);
    $this->policy->save();
  }

  /**
   * {@inheritdoc}
   */
  public function testConfigForm(): void {
    $assert = $this->assertSession();
    $page = $this->getSession()->getPage();

    $this->drupalLogin($this->adminUser);

    // Basic form settings.
    $edit = $this->getFormValues();

    // There must be at least two roles,
    // otherwise it won't be possible to select
    // purge_excluded_users_roles.
    $roles = \Drupal::entityTypeManager()->getStorage('user_role')->loadMultiple();
    $this->assertGreaterThanOrEqual(2, count($roles));

    $this->drupalGet('admin/config/people/purge-users/policies/test_policy');
    $assert->statusCodeEquals(200);

    // Submit the form.
    foreach ($edit as $key => $value) {
      $page->fillField($key, $value);
    }
    $page->findButton('Save')->press();
    $assert->statusCodeEquals(200);
    $assert->pageTextContains('The purge users policy Test policy has been updated.');

    // Verify form data.
    $this->drupalGet('admin/config/people/purge-users/policies/test_policy');
    $assert->statusCodeEquals(200);
    $assert->fieldValueEquals('purge_on_cron', TRUE);
    $assert->fieldValueEquals('purge_user_cancel_method', 'user_cancel_block');
    $assert->fieldValueEquals('disregard_blocked_users', FALSE);
    $assert->fieldValueEquals('send_email_notification', 'enabled');
    $assert->fieldValueEquals('send_email_user_before_notification', 'disabled');
  }

  /**
   * Returns the array with the form values to submit.
   *
   * @return array
   *   The array to use with formSubmit function.
   */
  protected function getFormValues(): array {
    $edit['purge_user_cancel_method'] = 'user_cancel_block';
    $edit['purge_on_cron'] = TRUE;
    $edit['send_email_notification'] = 'enabled';
    $edit['send_email_user_before_notification'] = 'disabled';

    return $edit;
  }

}
