<?php

declare(strict_types=1);

namespace Drupal\Tests\purge_users\Kernel\policy;

use Drupal\Tests\purge_users\Kernel\PurgeMethodTest;

/**
 * Covers what happens to purged users and their content.
 *
 * @group purge_users
 */
class PolicyPurgeMethodTest extends PurgeMethodTest {

  /**
   * Setup configuration for the test.
   */
  protected function setUpConfig(): void {
    // Set the basic policy configuration.
    $this->setBasicPolicyConfig();
  }

  /**
   * Setup configuration for the purge method test.
   *
   * @param array $settings
   *   Settings to be set in the configuration.
   */
  protected function setUpPurgeMethod(array $settings) {
    $policy = $this->getBasicPolicyConfig();
    $conditions = $policy->getConditions();
    // Set a purge condition.
    $conditions[] = [
      'id' => 'purge_users:never_logged_in',
      'user_never_lastlogin_value' => '2',
      'user_never_lastlogin_period' => 'year',
    ];
    $policy->set('policy_conditions', $conditions);
    $policy->save();

    // Settings from the data provider.
    // Usually this will be the purge method.
    foreach ($settings as $name => $values) {
      if ($name === 'purge_users.settings') {
        foreach ($values as $k => $v) {
          $policy->set($k, $v);
        }
        $policy->save();
      }
      else {
        $config = $this->config($name);
        foreach ($values as $k => $v) {
          $config->set($k, $v);
        }
        $config->save();
      }
    }
  }

}
