# Paragraph View Mode Selector

## Overview

The **Paragraph View Mode Selector** module provides a field type that allows content editors to select which view mode should be used to render individual paragraph entities.  
This enables flexible display configurations and improved layout control without requiring multiple paragraph types or custom Twig templates.

## Features

- Adds a **"View mode selector"** field type for paragraph entities.  
- Allows editors to choose from all available view modes defined for a paragraph type.  
- Integrates seamlessly with existing paragraph workflows.  
- Works with custom view modes defined via the UI or configuration.  
- Supports theming and render customization through Drupal’s standard view mode system.

## Use Case Example

You have a “Text + Image” paragraph type with multiple view modes (e.g., *Full*, *Compact*, *Highlighted*).  
By adding a *View Mode Selector* field to this paragraph type, editors can pick how each paragraph instance is displayed — giving more layout flexibility without duplicating content types.

## Installation

1. Install the module as usual:
   ```bash
   composer require drupal/paragraph_view_mode_selector
   drush en paragraph_view_mode_selector
    ```
2. Clear caches
    ```bash
    drush cr
    ```
## Configuration
1. Go to Structure → Paragraph types.
2. Choose the paragraph type you want to enhance.
3. Add a new field of type "Paragraph View Mode Selector".
4. Configure available view modes (optional — can be restricted per field instance).
5. Save and test by adding paragraphs to your content.

## Requirements
1. Drupal 10 or later
2. Paragraphs module

## Compatibility
1. Fully compatible with Drupal 10 and 11.
2. Works with Layout Builder and other display configuration tools.

## Development notes
1. The field stores the selected view mode as a string value.
2. Custom integrations can hook into the rendering process using hook_entity_view() or service decoration.

## Maintainers

Juan Lucas Pajin - [https://www.drupal.org/u/juanlucasp]