<?php

namespace Drupal\paragraph_view_mode_selector\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;

/**
 * Plugin implementation of the 'view_mode_select_formatter' formatter.
 *
 * @FieldFormatter(
 *   id = "paragraph_view_mode_select_formatter",
 *   label = @Translation("Paragraph View Mode Formatter"),
 *   field_types = {
 *     "paragraph_view_mode_select_field"
 *   }
 * )
 */
class ParagraphViewModeSelectFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];
    foreach ($items as $delta => $item) {
      $elements[$delta] = ['#markup' => $item->value];
    }
    return $elements;
  }
}
