<?php

namespace Drupal\paragraph_view_mode_selector\Plugin\Field\FieldType;

use Drupal\Core\Field\FieldItemBase;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\TypedData\DataDefinition;

/**
 * Provides a widget with dynamically loaded view modes.
 *
 * @FieldType(
 *   id = "paragraph_view_mode_select_field",
 *   module = "paragraph_view_mode_selector",
 *   label = @Translation("Paragraph View mode selector"),
*    description = @Translation("A field that allows selecting a view mode."),
 *   default_widget = "paragraph_view_mode_select_widget",
 *   default_formatter = "paragraph_view_mode_select_formatter"
 * )
 */
class ParagraphViewModeSelectField extends FieldItemBase
{

    /**
     * {@inheritdoc}
     */
    public static function schema(FieldStorageDefinitionInterface $field_definition)
    {
        return [
            'columns' => [
                'value' => [
                    'type' => 'varchar',
                    'length' => 255,
                ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition)
    {
        $properties['value'] = DataDefinition::create('string')
            ->setLabel(t('View Mode'));
        return $properties;
    }
}
