<?php 

namespace Drupal\paragraph_view_mode_selector\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\WidgetBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Plugin implementation of the 'view_mode_select_widget' widget.
 *
 * @FieldWidget(
 *   id = "paragraph_view_mode_select_widget",
 *   label = @Translation("Paragraph View Mode Select Widget"),
 *   field_types = {
 *     "paragraph_view_mode_select_field"
 *   }
 * )
 */
class ParagraphViewModeSelectWidget extends WidgetBase {

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    // The options needs to begin with the default, since it's not created that view mode.
    $options = [
      'default' => 'Default',
    ];
    $view_modes = \Drupal::service('entity_display.repository')->getViewModes('paragraph');
    
    foreach (array_keys($view_modes) as $key => $view_mode) {
      $options[$view_mode] = ucfirst(str_replace('_', ' ',$view_mode));
    }

    $element['value'] = [
      '#type' => 'select',
      '#title' => t('Select a View Mode'),
      '#options' => $options,
      '#default_value' => isset($items[$delta]->value) ? $items[$delta]->value : '',
    ];

    return $element;
  }
}
