# Module Drupal Pylot Bridge

## Installation
### Installer le module components
Le module components est utilisé pour gérer l'override des templates bridge dans un theme ou un module custom via les namespaces twig
https://www.drupal.org/project/components
- Utiliser le namespace pylot_bridge dans le fichier .info.yml
- Copier les fichiers twigs à overrider dans votre theme/module depuis le dossier templates du module pylot_bridge en respectant la même arborescence
- Chaque fichier twig peut être overridé individuellement, n'overrider que le minimum requis

### Installer le module Drupal Drush
Le module Drupal Drush est  utilisé pour lancer des commandes d'import
https://www.drupal.org/docs/develop/development-tools/drush

### Configuration des langues
* Aller dans Configuration > Régionalisation et langues > langues
* Ajouter les langues de traduction du site
* Activer la traduction de l'interface pour la langue anglaise, sinon les textes de Pylot Bridge seront en français sur l'interface anglaise
* Bridge supporte nativement : FR, EN , DE, ES, IT - si vous avez besoin d'une autre langue, contactez DN Consultants

### Installation du module
* Installer la dernière version : composer require 'drupal/pylot_bridge' 
* comme indiqué sur  https://www.drupal.org/project/pylot_bridge

### Configuration du module
* Aller dans Configuration > Système > Configuration Bridge
* Renseigner à minima les paramètres : URL Bridge, identifiant, Mot de passe Bridge, Id de site Bridge et n° de bloc photos Bridge

### Activation de la traduction du contenu
* Aller dans Configuration > Régionisation et langue > langues du contenu et traductions
* Cocher la case "Traduisible" sur Contenu > Fiche SIt et Terme > Rubrique SIT

### Activation du filtre de texte pour les shortcodes
* Aller dans Configuration > rédaction de contenu > format de texte et éditeur
* Pour chacun des format où vous souhaitez activer le shortcode, cliquer sur configurer et cocher la case "Pylot Bridge : shortcodes"
* Le shortcode de liste doit être formaté ainsi : [brliste id="XX"] où XX est un numéro de liste Bridge (copier-coller disponible depuis l'application Bridge)


## Commandes Drupal console ou Drush
### Import des données Bridge
`pylot_bridge:import`
* Importe les fiches Bridge en nodes de type fiche_sit et les listes Bridge en termes de la taxonomie rubrique_sit
* Met à jour les champs additionnels des fiches et termes
* Supprime les nodes qui ne sont plus dans les flux Bridge

`pylot_bridge:import_taxonomies`
* Importe uniquement les termes de la taxonomie rubrique_sit

`pylot_bridge:delete`
* Supprime toutes les fiches Bridge les termes de la taxonomie rubrique_sit

## Utilisation
Le module surcharge les vues d'affichage :
* Des nodes de type fiche_sit
* Des termes de taxonomie rubrique_sit

> En complément, les shortcodes permettent d'insérer des contenus dynamiques issus de Bridge dans des pages rédactionnelles.



# Changelog
## v11.0.0
* 02/01/2026
* [NOUVEAU] Nouveaux gabarits de liste : liste6, liste7, liste8 et liste9
* [NOUVEAU] Nouveaux gabarits de fiches : fiche4, fiche5, fiche6, fiche7, fiche_shortcode et fiche_shortcode2
* [AMELIORATION] Compatibilité Drupal 11
* [AMELIORATION] Mise à jour des dépendances composer

## v10.x-1.15.3
* 12/04/2025
* [AMELIORATION] Lors d'un appel à Bridge, l'id de site est désormais passé dans l'URL pour tracking 
* [AMELIORATION] Ajout du nom du site dans l'email d'erreur d'import
* [AMELIORATION] Filtre par distance : le premier niveau de recherche est désormais à 1km au lieu de 0
* [FIX] Templates twig : lors d'une recherche par ville, si celle-ci contient des accents, le nom de la ville s'affiche dans les templates alors qu'il ne devrait pas 

 
## v10.x-1.15.2
* 07/08/2024
* [FIX] Fiche MOSL - liens : en l'absence de http, le protocole par defaut passe désormais à https:// au lieu de http://
* 
## v10.x-1.15.1
* 27/06/2024
* [FIX] Crash lors de la redimension d'image si aucune dimension n'est passée

## v10.x-1.15.0
* 27/05/2024
* [REFACTO] Merge des versions 1.12.8 et 1.14.3

## v10.x-1.14.3
* 12/04/2024
* [REVERT] Retour à la version 1.12.3 (avant la recherche par déplacement de la carte et l'utilisation du cache Drupal) mais conservation des fixes apportés depuis 
* [RESOLU] Bug PHP 8.2 dans BridgeUtils::resizeImage (int) * (string)
* [RESOLU] Bug PHP 8.2 string to int conversion dans le twig extract-avis-tripadvisor.html.twig


## v10.x-1.14.2
* 09/04/2024
* [RESOLU] Dans le composant dates en tableau, le saut de ligne est parfois mal échappé


## v10.x-1.14.1
* 09/04/2024
* [RESOLU] Fiche mosl : le bouton réserver reste sur une page où l'intitulé devrait être acheter 
* [RESOLU] Le calendrier de dates d'ouverture n'est pas toujours positionné sur la bonne semaine

## v10.x-1.14.0
* 09/04/2024
* Retour sur la base de la release 1.12.6
* [RESOLU] La désactivation de pagination faisait planter les fiches associées/à proximité

## v10.x-1.13.2
* 04/04/2024
* [REFACTO] Rappatriement des commits depuis la 1.12.9 vers la 1.13.2

## v10.x-1.13.1
* 04/04/2024
* [REFACTO] Rappatriement des commits depuis la 1.12.6 vers la 1.13.1

## v10.x-1.13.0
* 04/04/2024
* [RESOLU] La désactivation de pagination faisait planter les fiches associés/à proximité

## v10.x-1.12.9
* 04/04/2024
* [RESOLU] La désactivation de pagination faisait planter les fiches associés/à proximité
* [RESOLU] Problème de style dans les résultats des items de filtre

## v10.x-1.12.8
* 22/03/2024
* [NOUVEAU] Ajout du nombre de résultat sur les filtres
* [NOUVEAU] Ajout d'une option dans les paramètres d'import de Bridge pour ne pas définir les alias d'URL
* [RESOLU] Mauvais intitulé dans le formulaire de contact

## v10.x-1.12.7
* 23/02/2024
* [RESOLU] Bouton "Réserver" au lieu de "Acheter"
* [RESOLU] Calendrier de la semaine décalé

## v10.x-1.12.6
* 05/02/2024
* [RESOLU] Crash lors du téléchargement d'un fichier sur les fiches rando
* [AMELIORATION] Gestion d'erreurs sur les requêtes mises en cache
* [AMELIORATION] Ajout d'un paramètre pour la durée de vie du cache Bridge

## v10.x-1.12.5
* 22/12/2023
* [AMELIORATION] Ajout d'un cache pour les requetes vers l'api bridge

## v10.x-1.12.4
* 26/10/2023
* [RESOLU] Problème de dates sur le tableau des horaires

## v10.x-1.12.3
* 26/10/2023
* [AMELIORATION] Support du plugin smtp en plus du plugin phpmailer_smtp

## v10.x-1.12.2
* 25/10/2023
* [NOUVEAU] Lancement d'import après les imports Bridge
* [AMELIORATION] Envoi d'email en cas d'erreur dans l'import Bridge
* [RESOLU] Le bouton Réserver affiche bien Acheter dans les fiches concernées

## v10.x-1.12.1
* 20/10/2023
* [RESOLU] Récupération de commits perdus des versions 1.11.10 à 1.11.5

## v10.x-1.12.0
* 19/10/2023
* [RESOLU] Plantage lors de l'import sur Drupal 10
* [RESOLU] Compatibilité Drupal 10

## v8.x-1.11.5
* 11/10/2023
* [FIX] La recherche par filtre ne prenait pas en compte la langue

## v8.x-1.11.4
* 09/10/2023
* [FIX] Problème de comptatibilité dans le composer.json

## v8.x-1.11.3
* 26/09/2023
* [FIX] Doublon dans la pagination qui pose des problèmes lors du crawl
* [FIX] le filtre par communes ne fonctionne plus après avoir cliqué sur le bouton de réinitialisation des filtre

## v8.x-1.11.2
* 12/09/2023
* [AMELIORATION] Amélioration des performances de l'import Bridge


## v8.x-1.11.1
* 25/08/2023
* [AMELIORATION] Support de l'affichage conditionnel des sections de moteurs gérés depuis l'application Pylot Bridge
* [RESOLU] Variable $quality non définie dans frontendController
* [RESOLU] Filtre Cityproxdyn : après une première recherche, les suivantes ne sont plus opérantes
* [RESOLU] le scroll de souris n'est pas bloqué sur la vue carte seule mosl ainsi que sur les composants fiches à proximité et fiches associées
* [FIX] Fix des arguments dans l'URL pour éviter des problèmes avec MATOMO

## v8.x-1.11.0
* 29/06/2023
*  [AMELIORATION] Support de l'affichage conditionnel des sections de moteurs gérés depuis l'application Pylot Bridge
*  [RESOLU] Variable $quality non définie dans frontendController
*  [RESOLU] Filtre Cityproxdyn : après une première recherche, les suivantes ne sont plus opérantes
*  [RESOLU] le scroll de souris n'est pas bloqué sur la vue carte seule mosl ainsi que sur les composants fiches à proximité et fiches associées

## v8.x-1.10.2
* 22/06/2023
* [NOUVEAU] Fond de carte Positron

## v8.x-1.10.1
* 13/06/2023
* [RESOLU] Les liens vers les réseaux sociaux ne fonctionnent pas toujours

## v8.x-1.10.0
* 24/05/2023
*  [AMELIORATION] Fiche Mosl : ajout d'une carte des producteurs directement dans le code, qui ne passe pas par le composant des fiches associées
*  [AMELIORATION] Moteurs : possibilité d'ajouter une image sur les checkbox
*  [AMELIORATION] Moteurs : possibilité d'avoir des valeurs derrière les cases à cocher
*  [AMELIORATION] Fiche mosl : carte des magasins où acheter (spécifique)
*  [AMELIORATION] Listes et fiches MOSL : ajout de la légende dans la balise title des photos de fiches
*  [RESOLU] Dans le composant de fiches associées, les fiches "hors territoire" remontent mais n'étant pas présentes dans le CMS, le lien vers la page de détail est mort

## v8.x-1.9.4
* 13/06/2023
* [RESOLU] Les liens de réseaux sociaux ne fonctionnent pas toujours

## v8.x-1.9.3
* 25/04/2023
* [RESOLU] Le nombre de fiches ne s'actualise plus lorsqu'on manipule le moteur de recherche
* [RESOLU] Les nouveaux composants profil altimétrique et Boutons de téléchargement de traces s'affichent même s'il n'y a aucune donnée de trace.

## v8.x-1.9.1
* 11/04/2023
* [RESOLU] Upgrade dncleafletservices

## v8.x-1.9.0
* 11/04/2023
* [NOUVEAU] Nouveaux composants de fiche (templates dans fiche/gabarits) : profil_altimetrique et itineraires/boutons_de_telechargement
* [NOUVEAU] Nouveaux template de fiche fiche-mosl-itineraire
* [AMELIORATION] Nouveau mode de navigation : infinite scroll avec bouton
* [AMELIORATION] Filtre par communes geolocalisées : le slider de distance est maintenant désactivé tant qu'aucune localisation n'est sélectionnée
* [AMELIORATION] dncleafletservice : ajout de deux nouveaux handlers d'évènements: beforeinit et afterinit qi permettent de définir les paramètres d'entrée et d'ajouter une logique d'init complémentaire
* [AMELIORATION] Templates twig : remplacement des tags include par une fonction bridge_include équivalente à la fonction twig include mais contenant l'invocation d'un hook alter sur les données et le template inclus
* [RESOLU] Le controlleur pylot_bridge/resize_image ne vérifie pas l'existence des images distantes avant la mise en cache du résultat
* [RESOLU] Les chemins vers le controlleur pylot_bridge/resize_image ne tiennent pas compte du préfixe de langue paramétré dans Drupal (redirection inutile)
* [RESOLU] les id html des listes sont uniques et empêchent de placer plusieurs listes sur la même page
* [RESOLU] Conflit dans le nom des templates twig input.html.twig => renommage de tous les templates de filtres
* [RESOLU] Bug Typo sur le nom de classe BridgeShortCodeParser

## v8.x-1.8.0
* 10/02/2023
* [NOUVEAU] Nouveau template mosl/carte-seule
* [NOUVEAU] Nouveaux composants de fiche fiches-a-proxmite et fuches-associees
* [NOUVEAU] Nouveau templates de liste : mosl-slider et mosl-slider-item
* [AMELIORATION] Ajout de paramètres supplémentaires dans les shortcodes
* [RESOLU] Modèle d'item de fiche pas pris en compte
* [RESOLU] latitude et longitude de centre de carte oublié
* [RESOLU] Les appels Ajax ne fonctionnenet plus en fr lorsqu'il n'y a pas de préfixe de langue /fr configuré sur le site


## v8.x-1.7.4
* 17/01/2023
* [RESOLU] Warning résiduel BridgeUtils line 304
* [RESOLU] Liste / moteur : Lors du clic sur le bouton "effacer tous les filtres", erreur JS calcMoteur is not a function
* [RESOLU] Les appels Ajax ne fonctionnenet plus en fr lorsqu'il n'y a pas de préfixe de langue /fr configuré sur le site 

## v8.x-1.7.3
* 13/01/2023
* FIX: l'id de fiche Bridge ne se mettait pas à jour pour les listes
* FIX: le carousel n'affichait pas l'image par défaut quand il n'y a pas d'image renseignée
* FIX: suppressions de warnings dans le BridgeUtils

## v8.x-1.7.2
* 19/12/2022
* FEAT : liste template sepcifique mosl/carte2 : insertion des avis tripadvisor dans le tag  <div class="card__review"> et déplacement de la zone commentaire dans le tag <div class="card__excerpt">

## v8.x-1.7
* 16/12/2022
* FEAT : nouveaux templates spécifique : mosl-slider et mosl-slider-item
* FEAT : nouvelle fonction BridgeShortCodeParser::process pour traiter les shortcodes d'un texte (récupération de tableaux de rendu et/ou de l'HTML filtré)

## v8.x-1.6.8
* 14/12/2022
* FEAT : fonction BridgeUtils::getBridgeCategories
* FIX : patchs templates calendar (espace superflu dans un attribut html)
* FEAT : liste application à la volée des traduction sur les balises title et description (intégration modif code Vanksen)

## v8.x-1.6.7
* 30/11/2022
* FEAT : templates MOSL : ajout de balises block twig pour donner une plus grande granularité dans les surcharges
* FEAT : MOSL : liste : ajout de la zone Commentaire dans une balie HTML <div class="card__review"> (affichage des avis TA dans la liste)
* FIX : correction syntaxe dans composer.json (virgules surnuméraires)
* FIX : MOSL : fiche : le lien vers Tripadvisor pointait tojours vers Tripadvisor en anglais => tient compte de la langue et redirige vers la bonne version de TripAdvisor (FR, DE, EN)
* FIX : MOSL : fiche : le nombre d'avis affiché était bloqué sur 120

## v8.x-1.6.6
* 07/11/2022
* FEAT : MOSL liste : ne pas zoomer la carte au survol d'un élément de liste mais simplement centrer

## v8.x-1.6.5
* 28/10/2022
* FEAT : ajout de blocks twig dans les templates de liste
* FEAT : fiche MOSL : ajout de la zone infos supplémentaires 5 en haut
* FEAT : mosl : ajout d'un bouton d'effacement de tous les filtres
* FEAT: mosl : le lien tripadvisor amène désormais a la section commentaires
* FIX : mosl liste : n'afficher que les points de la page courante sur la carte
* FIX : mosl : adaptation du script de déplacement du curseur distance
* FIX : lorsqu'on efface un filtre par gelocalisation, les informations restent en session
* FIX : mosl : intégration des overrides dans les vues spécifiques
* FIX : le lien vers l'itinéraire géolocalise désormais l'utilisateur en utilisant sa position précise
* FIX : fiche MOSL : ne pas faire apparaitre la colonne d'1/4 si pas de photo 2
* FIX : liste : lorsqu'on ne saisit qu'une date DU ou au, la date sélectionnée n'apparait pas dans les tags de recherche
* FIX : mosl liste :au chargement , la carte ne montre pas toujours tous les points
* FIX : ajout attribut uk-tooltip sur les images svg inline

## v8.x-1.6.4
* 21/10/2022`
* FEAT : fiche MOSL utilisation de la zone info supplémentaire 5
* FIX : correction fonction lien itinéraire


## v8.x-1.6.3
* 02/09/2022
* FEAT : fiche mosl : ajout de la zone pictogrammes par-dessus l'image princial dans le modèle de fiche
* FEAT : liste : affichage des seuls points de la page en cours sur la carte
* FEAT : filtre par distance : augmentation du maximum à  100km
* FEAT : fiche mosl : ajout des informations trip advisor
* FEAT : liste : lors d'une recherche géographique, ajout d'un pointeur localisant le point de recherche
* FEAT : fiche mosl : le lien de réservation apparait même lorsuq'il n'y a pas d'intitulé défini dans Bridge
* FIX : liste/fiche mosl : arrondissement de l'affichage de la distance par raport au point de recherche à 1 décimale
* FIX : le paramètres de cordonnées du centre de la carte interactive n'est pas pris en compte
* FIX : mosl correction sur le lien du boton itinéraire


## v8.x-1.6.2
* 13/07/2022
* FIX : bug sur le redimensionneur d'images (malformation last-modified lorsqu'on est pas connecté sur Drupal)

## v8.x-1.6.1
* 17/06/2022
* FIX : bug avec les paramètres de pointeur de carte


## v8.x-1.6
* 16/06/2022
* FEAT : nouveaux gabarits MOSL

## v8.x-1.5
* 23/05/2022
* FEAT : commandes Drush en plus des commande console
* FEAT : mise en cache des images redimensionnées
* FEAT : composant calendrier de disponibilités Avizi
* FEAT : passage des images SVG en balises html SVG au lieu des balises IMG
* FEAT : ajout de nouveaux paramètres sur les listes permettant de mieux gérer le rendu : "Afficher dans un conteneur", "Afficher le titre", "Afficher la description" et "Afficher l'image"
* FEAT : fiches : ajout de 2 nouvelles zones infos supplémentaires
* FEAT : fiches : ajout de 2 nouveaux composants liens de téléchargement
* FEAT : fiches : ajout du composant disponibilités LEI/SITLOR
* FEAT : fiches : ajout du composant tarifs en tableau (LEI alsace)
* FEAT : liste : support du mode pagination classique
* FEAT : composant player video
* FEAT : composants galeries photos
* FEAT : fiches : fonctionnalité formulaire de contact avec antispam recaptcha
* FEAT : fiches : ajout de balises sur les liens de contact pour tracking
* FEAT : nouveau shortcode brfiche

* FIX : mise à jour des fichiers de traductions pour prendre en compte les nouveaux messages ajoutés
* FIX : amélioration du rendu du slider de la fiche 1
* FIX : redimensionnement d'image incorrect sur les fiches
* FIX : améliorations CSS de cohérence de rendu selon les thèmes
* FIX : affichage incorrect des dates uniques sur les composants dates calendrier et dates tableau
* FIX : fiches : correction sur le positionnement des blocs infos supplémentaires
* FIX : fiches : interprétation des composants dans les zones infos supplémentaires
* FIX : fiches : calages responsive sur les fiches
* FIX : fiches : bug sur la zone lien de commercialisation
* FIX : fiches : ajout du sommaire sur modèle fiche 1
* FIX : fiches : prise en compte des paramètres de fiche concernant le sommaire
* FIX : listes : sur les modèles 1 et 2, en mobile lors du passage en carte plein écran, il n'y a plus de points
* FIX : listes : le loader passe sous la carte après un retour de carte plein écran
* FIX : listes : sur les modèles cartes, les pictogrammes n'apparaissent pas
* FIX : listes : limitation du nombre de liens de pagination
* OPT : listes : ne charger les points qu'au passage sur l'onglet carte pour les modèles sans carte directement visible
* OPT : listes : gestion plus fine du zoom sur hover ou click en passant par des classes css dédiées
* FIX : listes : fix d'affichage css
* FIX : listes : corrections de positionnement des zones info3 et info4 masquées sur les modèles de liste cartes
* FIX : listes : séparateurs non visibles dans certains blocs (bug dans RenderBlock)
* FIX : listes : désactivation de la bascule entre liste et carte par "Swipe" tactile
* FIX : listes : patch css taille de caractère des titres de fiches en liste
* FIX : améliorations sur la CSS de base

