<?php
namespace Bridge\Weblibs;



interface BridgeImportInterface
{
	public function update_lists_from_bridge(string $webListId = '', string $lang = '');

	/**
	 * Cette fonction met à jour les catégories de tous les posts selon les weblists de Bridge
	 * Elle met également à jour les règles de réécriture d'URL
	 * Et elle supprime les posts de type fiche-sit qui n'existent plus dans Bridge
	 * @return bool
	 */
	function updateRewriteRules($isCmdLine = false, $blogId = null, $lang = null);

	public function updatePostCategories();

	public function setLog($message, $type = 'info');

	public function getLog();

	public function setLogCallbackFunction($callbackFunction);

	public function doImport($isCmdLine = false, $blogId = null, $lang = null);

	public function doImportForLang($isCmdLine = false, $language = 'fr', $webListId = null);

	public function majLiensTrads($isCmdLine = false);

	/**
	 * Importe chaque produit et données associées, dont la catégorie
	 * @param mixed productToImport si isCmdLine = false : product est le productCode a importer
	 * @return bool
	 */
	function importPostByProductCodeAndLanguage($productToImport, $language, $term);

	public function deleteObsoletePosts($langs, $product_code);

	public function getErrorMsg();

	public function getWarnings();

	public function getCurrentLog();

	function get_http_response_code($url);

}
