<?php
namespace Bridge\Weblibs;



interface BridgeRequestServiceInterface
{
    /**
     * Récupère une donnée via un appel distant en utilisant le cache local volatile
     * @param string $url URL de la ressource à récupérer
     * @param bool $use_include_path si true, la fonction utilisera le include_path pour chercher le fichier
     * @param array|null $options tableau associatif de paramètres à passer à la fonction stream_context_create
     * @param int $cacheTimeMinutes durée de vie du cache en minutes
     * @return mixed contenu de la ressource ou false si échec
     */
    public function cachedFileGetContent(string $url, bool $use_include_path = false, $options = null, int $cacheTimeMinutes = 120);


	public function get($paramName, $default = null);

	public function getUrlLastModifiedTimestamp($fileUrl);

	public function getHashFromRequestParameters();

	public function getHashFromObjectOrArray($objectOrArray = null);


	public function getCachedData($cacheKey, $cacheTimeMinutes = 60 * 24 * 30);

	public function storeCachedData($cacheKey, $data);

}
