<?php

namespace Bridge\Weblibs\Joomla;

use Bridge\Weblibs\BridgeClientParamsInterface;
use Bridge\Weblibs\BridgeCmsAbstractLayerInterface;
use Bridge\Weblibs\BridgeRequestServiceInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Table\Table;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Uri\Uri;

class BridgeClientParamsJoomla implements BridgeClientParamsInterface
{
    private $requestService;
	private $bridgeCmsAbstractLayer;

    public function __construct(BridgeRequestServiceInterface $requestService, BridgeCmsAbstractLayerInterface $bridgeCmsAbstractLayer)
	{
		$this->requestService = $requestService;
		$this->bridgeCmsAbstractLayer = $bridgeCmsAbstractLayer;
    }

    /**
     * Retourne un tableau de Groupes d'options de markup HTML pour les listes (titres, conteneurs, etc.)
     * @return array Tableau de Groupes d'options de markup HTML pour les listes
     */
    public function getMarkupOptionGroups() {
        return array(
            'Listes et carrousels' => array(
                'tag_list_container' => 'Conteneur de liste',
                'tag_list_pagination' => 'Conteneur de pagination',
                'tag_listitem_container' => 'Conteneur d\'élément de liste',
                // 'list_titre' => 'Titre de liste', // kept commented like original
            ),
            'Eléments des listes et carrousels' => array(
                'tag_listitem_surtitre' => 'Surtitre',
                'tag_listitem_titre' => 'Titre',
                'tag_listitem_soustitre' => 'Sous-titre',
                'tag_listitem_commentaire' => 'Commentaire',
                'tag_listitem_pictogrammes' => 'Pictogrammes',
                'tag_listitem_info1' => 'Info1',
                'tag_listitem_info2' => 'Info2',
                'tag_listitem_info3' => 'Info3',
                'tag_listitem_info4' => 'Info4',
            ),
            'Moteur' => array(
                'tag_moteur_titre_section' => 'Titre de section',
                'tag_moteur_titre_subsection' => 'Titre de sous-section',
                'tag_moteur_titre_filtre' => 'Titre de filtre',
            ),
            'Fiche' => array(
                'tag_fiche_titre_infosupplementaires1' => 'Titre de bloc infos supplémentaires 1',
                'tag_fiche_titre_infosupplementaires2' => 'Titre de bloc infos supplémentaires 2',
                'tag_fiche_titre_infosupplementaires3' => 'Titre de bloc infos supplémentaires 3',
                'tag_fiche_titre_infosupplementaires4' => 'Titre de bloc infos supplémentaires 4',
                'tag_fiche_titre_infosupplementaires5' => 'Titre de bloc infos supplémentaires 5',
                'tag_fiche_titre_groupe_blocperso' => 'Titre de groupe de blocs perso',
                'tag_fiche_titre_blocperso' => 'Titre de bloc perso',
            ),
        );
    }

    /**
     * Retourne un tableau des options de balises HTML recommandées pour les listes (titres, conteneurs, etc.)
     * @return array Tableau des options de balises HTML recommandées pour les listes
     */
    public function getRecommendedMarkupOptions() {
        return array(
            'tag_list_container' => 'div',
            'tag_list_pagination' => 'nav',
            'tag_listitem_container' => 'div',
            'tag_listitem_titre' => 'h2',
            'tag_listitem_commentaire' => 'p',
            'tag_moteur_titre_section' => 'h2',
            'tag_moteur_titre_subsection' => 'h2',
            'tag_moteur_titre_filtre' => 'span',
            'tag_fiche_titre_infosupplementaires1' => 'h2',
            'tag_fiche_titre_infosupplementaires2' => 'h2',
            'tag_fiche_titre_infosupplementaires3' => 'h2',
            'tag_fiche_titre_infosupplementaires4' => 'h2',
            'tag_fiche_titre_infosupplementaires5' => 'h2',
            'tag_fiche_titre_groupe_blocperso' => 'h2',
            'tag_fiche_titre_blocperso' => 'h2',
        );
    }

    /**
     * @return array[] Tableau des options de balises HTML pour les listes déroulantes de sélection dans l'administration
     */
    public function getHtmlTagsForMarkupOptions() {
        return array(
            array('label' => '-- Sélectionnez --', 'value' => ''),
            array('label' => 'H1', 'value' => 'h1'),
            array('label' => 'H2', 'value' => 'h2'),
            array('label' => 'H3', 'value' => 'h3'),
            array('label' => 'H4', 'value' => 'h4'),
            array('label' => 'DIV', 'value' => 'div'),
            array('label' => 'SPAN', 'value' => 'span'),
            array('label' => 'P', 'value' => 'p'),
            array('label' => 'MAIN', 'value' => 'main'),
            array('label' => 'NAV', 'value' => 'nav'),
        );
    }
    /**
     * Retourne l'URL relative pour les appels AJAX des templates front-end qui lancent la récupération des données des listes
     */
    public function getAjaxURL() {
        return '/index.php?option=com_pylot_bridge&task=bridgeAjax.wpStyleAjax';
    }


    /**
     * Met à jour un réglage de Bridge en base de données
     *
     * @param $optionName
     * @param $optionValue
     */
    public function bridgeUpdateOption($optionName, $optionValue) {

    }

    /**
     * @return string code de la langue courante sur 2 lettres
     */
    public function getLanguage()
    {
		return $this->bridgeCmsAbstractLayer->getCurrentLanguage();
    }

    /**
     * @return string code de la langue courante sous la forme fr-FR ou en-GB (langue - pays)
     */
    public function getLanguageLocale()
    {
	    return $this->bridgeCmsAbstractLayer->getCurrentLanguageLocale();
    }

    /**
     * DRUPAL : Fonction indiquant le préfixe de langue à ajouter aux liens URL - sans objet dans Wordpress
     */
    public function getLanguagePrefix() {
        return '';
    }

    /**
     * @return mixed|string URL du serveur Pylot Bridge (application distante)
     */
    public function getBridgeUrl()
    {
	    $params = ComponentHelper::getParams('com_pylot_bridge');
	    return $params->get('url_bridge');
    }
    /**
     * Retounre l'URL de Pylot Bridge telle qu'enregistrée dans les paramètres
     * @return array|mixed|null URL de Pylot Bridge
     */
    public function getUrlBridge() {
        return $this->getBridgeUrl();
    }

    /**
     * @return mixed|string URL de la feuille de styles personnalisée définie dans le paramètres de l'extension
     */
    public function getCustomCssURl()
    {
	    $params = ComponentHelper::getParams('com_pylot_bridge');
	    return $params->get('custom_css_sit');
    }

    /**
     * @return mixed|string URL du script personnalisé défini dans le paramètres de l'extension
     */
    public function getCustomJsURl()
    {
	    $params = ComponentHelper::getParams('com_pylot_bridge');
	    return $params->get('custom_js_sit');
    }

    /**
     * @return object Paramètres de l'extension relatifs à l'affichage des cartes
     */
    public function getMapsDefaultSettings()
    {
	    $params = ComponentHelper::getParams('com_pylot_bridge');
        $obj = new \stdClass();
        $obj->latitude = '48.8534';
        if (!empty($params->get('maps_center_lat')))
            $obj->latitude = $params->get('maps_center_lat');
        $obj->longitude = '2.3488';
	    if (!empty($params->get('maps_center_lon')))
            $obj->longitude = $params->get('maps_center_lon');
        $obj->marker = Uri::root() . 'media/com_pylot_bridge/bridgewebfrontlibs/img/map-marker-icon.png';
	    if (!empty($params->get('marker_map')))
            $obj->marker = $params->get('marker_map');
        $obj->activeMarker = Uri::root() . 'media/com_pylot_bridge/bridgewebfrontlibs/img/map-marker-icon.png';
	    if (!empty($params->get('marker_map_actif')))
            $obj->activeMarker = $params->get('marker_map_actif');

        $obj->defaultGeolocIconUrl = Uri::root() . 'media/com_pylot_bridge/bridgewebfrontlibs/img/icon-map-geoloc.png';
	    if (!empty($params->get('marker_geoloc_actif')))
            $obj->defaultGeolocIconUrl = $params->get('marker_geoloc_actif');

        return $obj;
    }

    /**
     * @return false|mixed|string Chemin de base relatif à la réécriture des URL de taxonomies (hors permalien personnalisé)
     */
    public function getTaxonomyRootUrl()
    {
	    $params = ComponentHelper::getParams('com_pylot_bridge');
        if (!empty($params->get('taxonomy_root_url'))) {
            return $params->get('taxonomy_root_url');
        } else {
            return 'sit';
        }
    }

    /**
     * @return false|mixed|string Chemin de base relatif à la réécriture des URL des fiches (hors permalien personnalisé)
     */
    public function getFicheRootUrl()
    {
	    $params = ComponentHelper::getParams('com_pylot_bridge');
	    if (!empty($params->get('fiche_root_url'))) {
		    return $params->get('fiche_root_url');
	    } else {
		    return 0;
	    }
    }

    /**
     * Retourne l'URL du dossier du plugin Pylot Bridge
     * @return string URL du dossier du plugin Pylot Bridge
     */
    public function bridgeDirUrl()
    {
        return Uri::root() . 'components/com_pylot_bridge';
    }

    /**
     * Retournre le chemin physique du dossier du plugin Pylot Bridge
     * @return string Chemin du dossier du plugin Pylot Bridge
     */
    public function bridgeDirPath()
    {
        return str_replace('//', '/', JPATH_ROOT . '/components/com_pylot_bridge');
    }

    /**
     * Retourne le chemin physique du dossier des telmplates d'affichage du plugin Pylot Bridge
     * @return string URL du dossier des telmplates d'affichage du plugin Pylot Bridge
     */
    public function bridgeTemplatesPath()
    {
        return $this->bridgeDirPath().'';
    }

    /**
     * Retourne l'URL du script php de resizer d'image Bridge
     * @return string URL du resizer d'image Bridge
     */
    public function getResizeImage() {
	    return Uri::root() . "index.php?option=com_pylot_bridge&task=bridgeImage.resizeImage";
        //return $this->bridgeDirUrl().'/assets/resize_image_dnc.php';
    }

    /**
     * getResizeImageLink
     * Génère un lien d'image redimensionnée selon les paramètres passés
     * @param $url URL de la photo originale
     * @param string $mode mode de redimensonnement :
     * - ajust pour ajuster aux dimensions passées (ne déborde pas)
     * - remplir : pour remplir le cadre de dimensions passées
     * - deform : pour déformer l'image et forcer les dimensions exactes
     * @param string $width largeur souhaitée
     * @param string $height hauteur souhaitée
     * @param string $quality qualité de compresion (sur 100 pour le jpg et de 0 à 9 pour le png)
     * @param int $timeToCache durée de cache navigateur à indiquer dans l'en-tête http
     * @return string l'URL du service qui affiche les données d'image redimensionnée
     */
    public function getResizeImageLink($url, $mode = "ajust", $width = "150", $height = "150", $quality = "60", $timeToCache = "1800") {
		$resizeUrl = $this->getResizeImage();
		$sep = (strpos($resizeUrl, '?') === false) ? '?' : '&';
        return $resizeUrl . $sep . "lemode=$mode&selwidth=$width&selheight=$height&def=$quality&timeToCache=$timeToCache&file=" . urlencode($url);
    }

    /**
     * Retourne un objet contenant les paramètres de connexion au serveur Bridge (serveur et identifiants Bridge)
     *
     * @return object objets contenant les paramètres de connexion au serveur Bridge
     */
    public function getBridgeCredentials()
    {
	    $params = ComponentHelper::getParams('com_pylot_bridge');
        $obj = new \stdClass();
        $obj->urlBridge = $params->get('url_bridge');
        $obj->loginBridge = $params->get('login_bridge');
        $obj->passwordBridge = $params->get('password_bridge');
        return $obj;
    }

    /**
     * Permet de récupérer un token de connexion à l'API Bridge à partir d'identifiants
     *
     * @param string $url Url du serveur Bridge
     * @param string $login login Bridge
     * @param string $pw mot de passe Bridge
     * @throws \Exception
     * @return string token de connexion
     */
    public function getBridgeTokenFromCredentials(string $url, string $login, string $pw) {

        if ($url != '' && $login != '' && $pw != '') {
            $data = array(
                'username' => $login,
                'password' => $pw
            );
            $options = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => "Content-Type: application/json",
                    'ignore_errors' => true,
                    'timeout' => 10,
                    'content' => json_encode($data),
                )
            );

            $context = stream_context_create($options);
            $res = json_decode(file_get_contents($url . '/login_check', false, $context));

            if (isset($res) && isset($res->token)) {
                return $res->token;
            } else {
                throw new \Exception("Erreur de la connexion à l'API Bridge : Invalid credentials $url  $login  $pw ");
            }
        }
        return '';
    }

    /**
     * Permet de récupérer le token de connexion à l'API Bridge
     * @return string token de connexion à l'API Bridge
     * @throws \Exception
     */
    public function getBridgeToken($useCache = false)
    {
        $tmpOptions = $this->getBridgeCredentials();
        $urlBridge = $tmpOptions->urlBridge;
        $loginBridge = $tmpOptions->loginBridge;
        $passwordBridge = $tmpOptions->passwordBridge;

        return $this->getBridgeTokenFromCredentials($urlBridge, $loginBridge, $passwordBridge);
    }

    /**
     * Retounre l'id de site Pylot Bridge telle qu'enregistré dans les paramètres
     * @return array|mixed|null id de site Pylot Bridge
     */
    public function getSiteBridge() {
	    $params = ComponentHelper::getParams('com_pylot_bridge');
	    return $params->get('bridge_site');
    }

    /**
     * Retourne l'id du bock photos par défaut de Pylot Bridge tel qu'enregistré dans les paramètres
     * @return array|mixed|null id de bloc photos
     */
    public function getIdBlockPhotos() {
	    $params = ComponentHelper::getParams('com_pylot_bridge');
	    return $params->get('product_media_block');
    }

    /**
     * Retourne un tableau contenant les paramètres généraux du plugin Pylot Bridge ainsi que des données d'environnement
     * @return array tablea de paramètres
     */
    public function getBridgeParameters() {
        // On récupère les paramètres de Bridge pour les passer au Twig
        $bridgeParameters = array();


	    $params = ComponentHelper::getParams('com_pylot_bridge');
	    $obj = new \stdClass();
	    $obj->latitude = '48.8534';
	    if (!empty($params->get('maps_center_lat')))
		    $obj->latitude = $params->get('maps_center_lat');
	    $obj->longitude = '2.3488';
	    if (!empty($params->get('maps_center_lon')))
		    $obj->longitude = $params->get('maps_center_lon');
	    $obj->marker = Uri::root() . 'media/com_pylot_bridge/bridgewebfrontlibs/img/map-marker-icon.png';
	    if (!empty($params->get('marker_map')))
		    $obj->marker = $params->get('marker_map');
	    $obj->activeMarker = Uri::root() . 'media/com_pylot_bridge/bridgewebfrontlibs/img/map-marker-icon.png';
	    if (!empty($params->get('marker_map_actif')))
		    $obj->activeMarker = $params->get('marker_map_actif');

	    $obj->defaultGeolocIconUrl = Uri::root() . 'media/com_pylot_bridge/bridgewebfrontlibs/img/icon-map-geoloc.png';
	    if (!empty($params->get('marker_geoloc_actif')))
		    $obj->defaultGeolocIconUrl = $params->get('marker_geoloc_actif');


        $bridgeParameters['fiches_iframe'] = '';
        $bridgeParameters['marker_map'] = $params->get('marker_map');
        $bridgeParameters['marker_map_actif'] = $params->get('marker_map_actif');
        $bridgeParameters['url_bridge'] = $params->get('url_bridge');
        $bridgeParameters['custom_css_sit'] = $params->get('custom_css_sit');
        $bridgeParameters['custom_js_sit'] = $params->get('custom_js_sit');
        $bridgeParameters['bridge_site'] = $params->get('bridge_site');
        $bridgeParameters['product_media_block'] = $params->get('product_media_block');
        $bridgeParameters['maps_center_lat'] = $params->get('maps_center_lat');
        $bridgeParameters['maps_center_lon'] = $params->get('maps_center_lon');
        $bridgeParameters['model_selector'] = $params->get('model_selector');

        if(empty($bridgeParameters['maps_center_lat']))
            $bridgeParameters['maps_center_lat'] = 48.856614;
        if(empty($bridgeParameters['maps_center_lon']))
            $bridgeParameters['maps_center_lon'] = 2.3522219;

        $rootUrl = Uri::root();
        $bridgePath = $this->bridgeDirUrl();
        $bridgeParameters['url_root'] = $rootUrl;
        $bridgeParameters['url_module_bridge'] = $bridgePath;
        $uri_parts = explode('?', $_SERVER['REQUEST_URI'], 2);
        $bridgeParameters['currentUrl'] = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$uri_parts[0]" ;

        // Paramètres d'URL pour la pagination des listes
        $paginationUrlParams = $_SERVER['QUERY_STRING'] ;
        if(!empty($paginationUrlParams)) {
            $tabUrlParams = array();
            parse_str($paginationUrlParams, $tabUrlParams);
            // On retire le paraetre brpa de l'url courante pour construire les liens de pagination
            if(isset($tabUrlParams['brpa'])) {
                unset($tabUrlParams['brpa']);
                $paginationUrlParams = http_build_query($tabUrlParams);
            }
            if(!empty($paginationUrlParams))
                $paginationUrlParams = '?' . $paginationUrlParams;
        }
        $bridgeParameters['paginationUrlParams'] = $paginationUrlParams;

        if(empty($bridgeParameters['marker_map']))
            $bridgeParameters['marker_map'] = $bridgeParameters['url_module_bridge'] . '/assets/img/map-marker-icon.png';
        if(empty($bridgeParameters['marker_map_actif']))
            $bridgeParameters['marker_map_actif'] = $bridgeParameters['marker_map'] ;

        // On donne des dimensions proportionnelles au marker avec en visée 50 px de haut
        if(strtolower(substr($bridgeParameters['marker_map'], -3)) == 'svg') {
            $markerImage = $this->requestService->cachedFileGetContent($bridgeParameters['marker_map']);
            if(!empty($markerImage)) {
                try {
                    $xml = simplexml_load_file( $bridgeParameters['marker_map'] );

                    $attr = $xml->attributes();
                    if ( is_object( $attr ) && isset( $attr->width ) && isset( $attr->height ) ) {
                        $ratio                                 = 50 / (int) $attr->height;
                        $bridgeParameters['marker_map_width']  = round( (int) $attr->width * $ratio );
                        $bridgeParameters['marker_map_height'] = round( (int) $attr->height * $ratio );
                    } else {
                        $bridgeParameters['marker_map_width']  = 35;
                        $bridgeParameters['marker_map_height'] = 50;
                    }
                } catch ( \Exception $e ) {
                    $bridgeParameters['marker_map_width']  = 35;
                    $bridgeParameters['marker_map_height'] = 50;
                }
            }
        } else {
            $image_info = getImageSize($bridgeParameters['marker_map']);
            if(isset($image_info[1]))
                $ratio = 50 / $image_info[1];
            else
                $ratio = 1;
            $bridgeParameters['marker_map_width'] = round($image_info[0] * $ratio);
            $bridgeParameters['marker_map_height'] = round($image_info[1] * $ratio);
        }

        if(strtolower(substr($bridgeParameters['marker_map_actif'], -3)) == 'svg') {
            $markerActifImage = $this->requestService->cachedFileGetContent($bridgeParameters['marker_map_actif']);
            if(!empty($markerActifImage)) {
                try {
                    $xml = simplexml_load_file( $bridgeParameters['marker_map_actif'] );

                    $attr = $xml->attributes();
                    if ( is_object( $attr ) && isset( $attr->width ) && isset( $attr->height ) ) {
                        $ratio                                       = 50 / (int) $attr->height;
                        $bridgeParameters['marker_map_actif_width']  = round( (int) $attr->width * $ratio );
                        $bridgeParameters['marker_map_actif_height'] = round( (int) $attr->height * $ratio );
                    } else {
                        $bridgeParameters['marker_map_actif_width']  = 35;
                        $bridgeParameters['marker_map_actif_height'] = 50;
                    }
                } catch ( \Exception $e ) {
                    $bridgeParameters['marker_map_actif_width']  = 35;
                    $bridgeParameters['marker_map_actif_height'] = 50;
                }
            }
        } else {
            $image_info = getImageSize($bridgeParameters['marker_map_actif']);
            if(isset($image_info[1]))
                $ratio = 50 / $image_info[1];
            else
                $ratio = 1;
            $bridgeParameters['marker_map_actif_width'] = round($image_info[0] * $ratio);
            $bridgeParameters['marker_map_actif_height'] = round($image_info[1] * $ratio);
        }

        // TODO : vérifier ces paramètres, ça me semble très drupalien
		// On ajoute aux paramètres d'application les constantes système de manière à tout avoir sous la main et ne pas avoir à faire trop d'appels
        $bridgeParameters['url_ajax_liste'] = $rootUrl . '/pylot_bridge/list_products_json' ;
        $bridgeParameters['url_ajax_liste_json_poi'] = $rootUrl . '/pylot_bridge/list_products_json_for_map_poi' ;

        // Et la langue courante tant qu'on y est
        $bridgeParameters['lang'] = $this->getLanguage();

        // Facebook App Id pour la social box
        $bridgeParameters['facebookAppId'] = '495036869019149';
        $bridgeParameters['facebookAppNonce'] = 'awkTZqCe';

        return $bridgeParameters;
    }


	/**
	 * @return mixed|string Pour la demande d'import en tâche de fond
	 */
	public function getNeedToImport()
	{
		$params = ComponentHelper::getParams('com_pylot_bridge');
		return $params->get('need_to_import');
	}

	/**
	 * @return mixed|string Pour la demande d'import en tâche de fond
	 */
	public function setNeedToImport($val)
	{
		$params = ComponentHelper::getParams('com_pylot_bridge');
		return $params->set('need_to_import', $val);
	}

	public function getCvPreviewLink() {
		$params = ComponentHelper::getParams('com_pylot_bridge');
		$cvPreviewId = $params->get('cv_preview_page');
		$cvPreviewLink = Factory::getApplication()->getRouter()->build('index.php?option=com_content&view=article&id='.$cvPreviewId);
		return $cvPreviewLink;
	}

	public function getCvDownloadLink() {
		return '/index.php?option=com_pylot_bridge&task=bridgeAjax.dlCarnetVoyage';
	}

	public function getLastImportLog() {
		$params = ComponentHelper::getParams('com_pylot_bridge');
		return $params->get('last_import_log');
	}
	public function setLastImportLog($txt) {
		$params = ComponentHelper::getParams('com_pylot_bridge');
		$params->set('last_import_log', $txt);
		$db    = Factory::getContainer()->get('DatabaseDriver');
		$query = "UPDATE #__extensions SET params=" . $db->quote($params->toString()) . " WHERE element='com_pylot_bridge';";
		$db->setQuery($query);
		$db->execute();

		/*$ligne = $db->loadObject();
		$oldParams = json_decode($ligne->params);
		// print_r($oldParams);
		$oldParams->last_import_log = $txt;
*/
		// die('gg');
// die('PARAMS OLD : ' . $ligne->params . ' NEW : '. $params->toString()); // json_encode($oldParams));


	}

    /**
     * @return string URL du dossier des images du plugin Pylot Bridge
     */
    public function getBridgeImgUrl() {
        // TODO : modifier pour corresponddre au dossier joomla
        return Uri::root() . 'media/com_pylot_bridge/bridgewebfrontlibs/img';
    }

    public function cachedFileGetContent(string $url, bool $use_include_path = false, $options = null, int $cacheTimeMinutes = 120) {
        return $this->requestService->cachedFileGetContent($url, $use_include_path, $options, $cacheTimeMinutes);
    }
}
