<?php
namespace Bridge\Weblibs\Joomla;

use Bridge\Weblibs\BridgeClientParamsInterface;
use Bridge\Weblibs\BridgeCmsAbstractLayerInterface;
use Bridge\Weblibs\BridgeClientContentInterface;
use Bridge\Weblibs\BridgeImportInterface;
use Joomla\CMS\Factory;

class BridgeImportJoomla implements BridgeImportInterface
{
	private BridgeClientParamsInterface $clientParams;
	private BridgeCmsAbstractLayerInterface $bridgeCmsAbstractLayer;
	private BridgeClientContentInterface $clientContentService;
	private $errorMsg;
	private $totalWebLists;
	private $logCallbackFunction;

	private $alreadyImportedProducts = array();

	private $currentForcedLang = '';

	private $isCmdLine = false;

	private $log = [];


	private $debugTimeBridgeCalls = 0 ;
	private $debugTimeSql = 0 ;
	private $debugTimeTotal = 0 ;
	private $debugTimePhotos = 0 ;

	private $tmpDebug  = false;

	public function __construct(BridgeClientParamsInterface $clientParams, BridgeClientContentInterface $clientContentService, BridgeCmsAbstractLayerInterface $bridgeCmsAbstractLayer) {
		$this->bridgeCmsAbstractLayer = $bridgeCmsAbstractLayer;
		$this->clientParams = $clientParams;
		$this->clientContentService = $clientContentService;
	}

	/**
	 * @param   string  $webListId
	 * @param   string  $lang
	 *
	 * @return bool|string
	 *
	 * @since version 1.0.0
	 */
	public function update_lists_from_bridge(string $webListId = '', string|null $lang = '')
	{

		$urlBridge = $this->clientParams->getBridgeUrl();
		$siteId = $this->clientParams->getSiteBridge();

		if(!empty($this->currentForcedLang)) {
			$languages = array($this->currentForcedLang);
		} else {
			$languages = $this->bridgeCmsAbstractLayer->getLanguagesList();
		}

		// si on n'importe pas une liste en particulier mais toutes
		if (empty($webListId)) {
			$this->setLog('Import de toutes les listes depuis le bridge');
			$urlImport = $urlBridge . "/weblist/getForImport?v2=1";
			// si un site est enregistré, on n'update que les données associées à ce site
			if (!empty($siteId)) {
				$urlImport = $urlImport . '&site=' . $siteId;
			}

			$data = array();
			$doublonsListSlug = array();

			$tmpData = file_get_contents($urlImport);
			if (!empty($tmpData)) {
				$tmpDataDecoded = json_decode($tmpData);
				if ($tmpDataDecoded->success) {
					$data = $tmpDataDecoded->data;
				} else {
					$this->errorMsg = $tmpDataDecoded->message;
					return false;
				}
			} else {
				$this->errorMsg = "ERREUR : Échec de l'import des listes depuis l'URL " . $urlImport;
				return false;
			}

			if (!empty($data) && is_array($data)) {
				$this->totalWebLists = count($data);

				foreach ($languages as $key => $lang) {
					$langUpper = strtoupper($lang);

					// Tableau des welistes actives pour suppression des termes obsolètes
					$tabWebListIds = [];
					// On parcourt les WebLists
					foreach ($data as $webList) {
						$tabWebListIds[] = $webList->id;
						$slug = $webList->slug;
						$permalink = $webList->permalinkUrl;
						// Ici on gère le permalien de destination
						if(!empty($webList->destinationWebListId))
							$permalink = $webList->destinationWebListPermalinkUrl;
						$title = $webList->title;
						$description = $webList->description;
						$this->setLog('Import de la liste ' . $title . '(n°' . $webList->id . ') en ' . $lang . '');

						if ($lang != 'fr' && isset($webList->slugTranslation) && is_object($webList->slugTranslation) && isset($webList->slugTranslation->$langUpper)) {
							$slug = $webList->slugTranslation->$langUpper;
							$permalink = isset($webList->permalinkUrlTranslation->$langUpper) ? $webList->permalinkUrlTranslation->$langUpper : null;
							// Ici on gère le permalien de destination
							if(!empty($webList->destinationWebListId)) {
								if (!empty($webList->destinationWebListPermalinkUrlTranslation->$langUpper))
									$permalink = $webList->destinationWebListPermalinkUrl;
								else
									$permalink = null;
							}
							$title = $webList->titleTranslations->$langUpper;
							$description = $webList->descriptionTranslations->$langUpper;
						} elseif($lang != 'fr') {
							// Ajout Nicolas 13/10/2022 : on importe pas les listes qui n'ont pas de slug traduit
							$title = '';
							$slug = '';
						}
						if (empty($slug) && !empty($title)) {
							// Sur Joomla c'est pas trop grave le slug vide je crois
							// $this->errorMsg = "ERREUR 3 : Slug vide dans la liste n°" . $webList->id . " (" . $lang . ")";
							// return false;
						}

						if (empty($title) && empty($slug)) {
							continue;
						}
						if (empty($title) && !empty($slug)) {
							$title = $slug;
						}

						$term = null;
						// On cherche si le term (catégorie) existe
						$term = $this->clientContentService->getTermFromListId($webList->id, $lang);
						// Ici on doit s'assurer que le slug n'est pas déjà pris pour une autre weblist ou pour la même dans une autre langue (doublon de slug)
						if (isset($term)) {
							$testWebListId = $term->list_id;
						} else {
							$term = $this->clientContentService->createTerm($title, $slug, $description, $webList, $permalink, $lang);
						}
						$term = $this->clientContentService->updateTermFromWebList($term, $title, $slug, $description, $webList, $permalink, $lang);
					} // Fin foreach weblist


					// suppression des termes obsolètes
					$this->setLog('Suppression des rubriques obsolètes');
					$terms = $this->clientContentService->getAllTerms($lang);
					foreach ($terms as $term) {
						$weblistId = $this->clientContentService->getWebListIdFromTermObject($term);
						if (!in_array($weblistId, $tabWebListIds)) {
							$this->clientContentService->deleteTermObject($term);
						}
					}
				} // fin foreach langues
			} else {
				$this->errorMsg = 'Aucune liste à importer - Bridge est peut-être inaccessible - Code 1';
				return false;
			}
		} else {
			// JM 22/03/2022 : on change le nom du paramètre (update -> v2), moins risqué
			$urlImport = $urlBridge . "/weblist/getForImport?id=" . $webListId . '&language=' . $lang . '&v2=1';

			// si un site est enregistré, on n'update que les données associées à ce site
			if (!empty($siteId) && $siteId !== -1) {
				$urlImport = $urlImport . '&site=' . $siteId;
			}

			$webList = array();
			$tmpWebList = file_get_contents($urlImport);

			if (!empty($tmpWebList)) {
				$tmpWebListDecoded = json_decode($tmpWebList);
				if ($tmpWebListDecoded->success) {
					$webList = $tmpWebListDecoded->data;
				} else {
					$this->errorMsg = $tmpWebListDecoded->message;
					return false;
				}
			} else {
				$this->errorMsg = "ERREUR : Échec de l'import de la liste " . $webList . ' (' . $lang . ") depuis l'URL " . $urlImport;
				return false;
			}

			if (!empty($webList) && is_array($webList) && count($webList) > 0) {
				$slug = $webList[0]->slug;
				$permalink = $webList[0]->permalinkUrl;
				$title = $webList[0]->title;
				$description = $webList[0]->description;
				$langUpper = strtoupper($lang);


				if ($lang !== 'fr') {
					$slug = $webList[0]->slugTranslation->$langUpper;
					$permalink = isset($webList[0]->permalinkUrlTranslation->$langUpper) ? $webList[0]->permalinkUrlTranslation->$langUpper : null;
					$title = $webList[0]->titleTranslations->$langUpper;
					$description = $webList[0]->descriptionTranslations->$langUpper;
				}

				// Ici on gère le permalien de destination : en fait on ne créé par de term pour la liste originale
				if(!empty($webList[0]->destinationWebListId)) {
					$permalink = $webList[0]->destinationWebListPermalinkUrl;
					if ($lang !== 'fr') {
						$permalink = isset($webList[0]->destinationWebListPermalinkUrlTranslation->$langUpper) ? $webList[0]->destinationWebListPermalinkUrlTranslation->$langUpper : null;
					}
				}


				if (!empty($title) && empty($slug)) {
					$this->errorMsg = "ERREUR 1 : Slug vide dans la liste n°" . $webList[0]->id . " (" . $lang . ")";
					return false;
				}

				if (empty($title) && empty($slug)) {
					return 'skip';
				}

				if (empty($title) && !empty($slug)) {
					$title = $slug;
				}

				$term = null;
				// On cherche si le term (catégorie) existe
				$term = $this->clientContentService->getTermFromListId($webList[0]->id, $lang);

				// S'il n'existe || $term == '' pas on le crée
				if (empty($term)) {
					$this->clientContentService->createTerm($title, $slug, $description, $webList[0], $permalink, $lang);
				}


				if (!empty($permalink)) {
					if (substr($permalink, -1, 1) == '/')
						$permalink = substr($permalink, 0, -1);
					if (substr($permalink, 0, 1) == '/')
						$permalink = substr($permalink, 1);
					update_term_meta($term['term_id'], 'permalien', $permalink);
				} else {
					delete_term_meta($term['term_id'], 'permalien');
				}

				$this->clientContentService->updateTermFromWebList($term, $title, $slug, $description, $webList[0], $permalink, $lang);
				/*
				// On mémorise l'id de weblist dans le meta du terme
				update_term_meta($term['term_id'], 'weblist_id', $webList[0]->id);
				update_term_meta($term['term_id'], 'weblist_ficheId', $webList[0]->ficheId);
				update_term_meta($term['term_id'], 'weblist_destinationWebListId', $webList[0]->destinationWebListId);
				update_term_meta($term['term_id'], 'weblist_doNotCreateRewriteRuleForList', $webList[0]->doNotCreateRewriteRuleForList);
				update_term_meta($term['term_id'], 'weblist_permalinkIsCanonical', $webList[0]->permalinkIsCanonical);
				*/
			} else {
				$this->errorMsg = 'Aucune liste à importer - Bridge est peut-être inaccessible - Code 2';
				return false;
			}
		}
		return true;
	}

	public function updatePostCategories()
	{

		$this->setLog('Mise à jour des catégories de posts');

		$res = array(
			'success' => false,
			'tabPosts' => array(),
			'productsInBridge' => array()
		);
		$siteId = $this->clientParams->getSiteBridge();

		// Options connexion à Bridge
		$urlBridge = $this->clientParams->getBridgeUrl();

		// si un site est sélectionné, on n'update que les listes associées à ce site
		// JM 22/03/2022 : on change le nom du paramètre (update -> v2), moins risqué
		$urlImport = $urlBridge . "/weblist/getAllProductCategories?v2=1";
		if (!empty($siteId)) {
			$urlImport = $urlImport . '&site=' . $siteId;
		}

		// $languages = BridgeUtils::getLanguagesList();
		// Ce tableau servira à savoir quelles fiches doivent être supprimées de WordPress car absentes de Bridge
		// On y stocke des product codes
		$productsInBridge = array();

		// On récupère de Bridge toutes les weblists et leurs fiches associées
		$data = array();

		$tmpData = file_get_contents($urlImport);

		if (!empty($tmpData)) {
			$tmpDataDecoded = json_decode($tmpData);
			if ($tmpDataDecoded->success) {
				$data = $tmpDataDecoded->data;
				$data = (array)$data;
				$this->setLog($urlImport.' il y a '.count($data).' fiches');
			} else {
				$this->errorMsg = $tmpDataDecoded->message;
				return false;
			}
		} else {
			$this->setLog('Échec de la récupération des catégories');
			$this->errorMsg = "Échec de la récupération des catégories";
			return false;
		}

		if (!empty($data)) {
			// On construit un tableau d'associations productCode <=> postID à partir des données WordPress
			$this->setLog("On construit un tableau d'associations productCode <=> postID à partir des données WordPress");
			// Patch 01.11.22 : on a des post_meta avec post_id = 0 !!!!
			// $sql = "SELECT post_id, meta_value FROM " . $this->currentDbPrefix . "postmeta WHERE meta_key = 'bridge_productCode' and post_id != 0";
			// $products = $wpdb->get_results($sql);


			$db    = Factory::getContainer()->get('DatabaseDriver');
			$query = "SELECT * FROM #__pylot_bridge_fiches_sit ;";
			$db->setQuery($query);
			$posts = $db->loadObjectList();


			$tabPosts = array();

			if (!empty($posts) && is_array($posts)) {
				foreach ($posts as $post) {
					$productCode = $post->product_code;
					$postId = $post->id;
					if(empty($this->currentForcedLang)) {
						$lang = $post->lang;
					} else {
						$lang = $this->currentForcedLang;
					}
					if (!isset($tabPosts[(string)$productCode])) {
						$tabPosts[(string)$productCode] = array();
					}

					$tabPosts[(string)$productCode][$lang] = $postId;
				}
				if (!$this->isCmdLine) {
					$res['tabPosts'] = $tabPosts;
				}
			} else {
				$this->errorMsg = "Erreur à la récupération des produits. Vérifiez que la base n'est pas vide.";
				return false;
			}

			// On construit un tableau d'associations weblistId <=> term_id
			$this->setLog("On construit un tableau d'associations weblistId <=> term_id à partir des données WordPress");
			$db    = Factory::getContainer()->get('DatabaseDriver');
			$query = "SELECT * FROM #__pylot_bridge_rubriques ;";
			$db->setQuery($query);
			$terms = $db->loadObjectList();

			$tabTerms = array();
			if(is_array($terms) && !empty($terms)) {
				foreach ($terms as $term) {
					// Le numéro de WebList sert d'identifiant entre langues
					$webListId = $term->list_id;
					if(empty($this->currentForcedLang)) {
						$lang = $term->lang;
					} else {
						$lang = $this->currentForcedLang;
					}
					if (!isset($tabTerms[(string)$webListId]))
						$tabTerms[(string)$webListId] = array();

					$tmp = new \stdClass();
					$tmp->term_id = $term->id;
					$tmp->permalink = $term->permalink;
					$tmp->is_canonical = $term->permalink_is_canonical;
					$tabTerms[(string)$webListId][$lang] = $tmp;
				}
			}

			// Maintenant on peut mettre à jour toutes les catégories de tous les posts
			foreach ($data as $product_code => $infos) {
				// On référence le productCode comme étant dans Brigde
				if(!in_array($product_code, $productsInBridge))
					$productsInBridge[] = $product_code;
				// On retrouve le post pour lui affecter les catégories selon les weblists
				$posts = $tabPosts[(string)$product_code];
				/* if((string) $product_code == '223012199') {
					print_r($posts);
					die('stop 223012199');
				} */
				if (!empty($posts)) {
					foreach ($posts as $lang => $postId) {
						$postTerms = array();
						$rubrique_principale = '';
						if (!empty($infos->categories)) {
							foreach ($infos->categories as $webList) {
								if (isset($tabTerms[( string )$webList->id]) && isset($tabTerms[( string )$webList->id][$lang])) {
									$postTerms[] = $tabTerms[$webList->id][$lang]->term_id;
									if($tabTerms[$webList->id][$lang]->is_canonical)
										$rubrique_principale = $tabTerms[$webList->id][$lang]->term_id;
								}
							}
						}

						// Specifique Joomla, on ne peut pas avoir du ''
						if(empty($rubrique_principale))
							$rubrique_principale = 0;

						$query = $db->getQuery(true);
						$query->update('#__pylot_bridge_fiches_sit');
						$query->set('rubrique_principale=' . $db->quote($rubrique_principale))
							->set('rubriques=' . $db->quote(implode(',', $postTerms)))
							->where('id=' . $postId);
						$db->setQuery($query);
						$db->execute();
					}
				} else {
					// echo "\n count tabposts : " . count($tabPosts) . " count data : " . count($data) . "\n";
					// Patch 24/08 : on tolère que certaines catégories ne soient pas bien importées (en mode multisite multilangue, ça peut arriver)
					$this->setLog('Warning : il n\'y a pas de post pour le poduit n°' . $product_code);
					// $this->errorMsg = 'Pas de posts à traiter';
					// return false;
				}
			}

			$this->setLog('Mise à jour des catégories de posts terminée');

			// si on est en ligne de commande on appelle directement la suite
			if ($this->isCmdLine) {
				$this->setLog('Suppression des posts obsolètes');
				foreach ($tabPosts as $product_code => $langs) {
					if (!in_array((string)$product_code, $productsInBridge)) {
						// $this->setLog($product_code);
						$this->deleteObsoletePosts($langs, $product_code);
						//$this->setLog("DEBUGGAGE - Suite à la suppression inopinnée de la fiche");
					}
				}
				$this->setLog('Suppression des posts obsolètes terminée');
				return true;
			} else {
				// si on est en AJAX on retourne les données nécessaires pour relancer ensuite un appel par fiche
				$res['success'] = true;
				$res['productsInBridge'] = $productsInBridge;
				return $res;
			}
		} else {
			if (!$this->isCmdLine) {
				$res['success'] = true;
				return $res;
			}
		}
		return $res;
	}

	public function setLog($message, $type = 'info')
	{
		if(!isset($this->log[$type])) {
			$this->log[$type] = [];
		}
		$this->log[$type][] = $message;
		if(isset($this->logCallbackFunction)) {
			$this->doLogCallback($this->logCallbackFunction, $message, $type);
		}
	}

	public function getLog()
	{
		return $this->log;
	}
	public function setLogCallbackFunction($callbackFunction)
	{
		$this->logCallbackFunction = $callbackFunction;
	}

	private function doLogCallback(callable $callbackFunction, $message, $type = 'info')
	{
		$callbackFunction($message, $type);
	}

	public function doImport($isCmdLine = false, $blogId = null, $lang = null)
	{
		$this->isCmdLine = $isCmdLine;

		// On commence par importer les catégories (= weblists)
		$this->setLog("Mise à jour des catégories\n");

		if(!empty($lang)) {
			$this->currentForcedLang = $lang;
		}

		$tmp = $this->update_lists_from_bridge('', $lang);

		if (!$tmp) {
			$this->errorMsg = 'Erreur lors de la mise à jour des catégories : ' . $this->errorMsg;
			return false;
		}

		// Puis les autres langues
		if(!empty($this->currentForcedLang)) {
			$languages = array($this->currentForcedLang);
		} else {
			$languages = $this->bridgeCmsAbstractLayer->getLanguagesList();
		}


		// Pour éviter de réimporter plusieurs fois la même fiche
		$this->alreadyImportedProducts = array();

		foreach ($languages as $key => $lang) {
			$this->alreadyImportedProducts[$lang] = array();
			$temp = $this->doImportForLang($this->isCmdLine, $lang);
			if (!$temp) {
				// $this->errorMsg = 'Erreur lors de l\'import en ' . $lang;
				return false;
			}
		}

		$this->setLog('Import des fiches terminé');

		/* $res = $this->updateRewriteRules($this->isCmdLine);
		if (!$res) {
			$this->errorMsg = 'Erreur lors de la mise à jour des règles de réécriture';
			return false;
		} */

		// $this->setLog("Mise à jour des liens de traduction");
		// Après les imports, on met à jour les liens entre catégories et entre posts SIT en langues
		/* $res = $this->majLiensTrads($this->isCmdLine);
		if (!$res) {
			$this->errorMsg = 'Erreur lors de la mise à jour des liens de traduction';
			return false;
		}
		*/
		return true;
	}

	public function doImportForLang($isCmdLine = false, $language = 'fr', $webListId = null)
	{
		$this->debugTimeBridgeCalls = 0 ;
		$this->debugTimeSql = 0 ;
		$this->debugTimeTotal = 0 ;
		$this->debugTimePhotos = 0 ;
		$langUpper = strtoupper($language);

		$this->isCmdLine = $isCmdLine;
		$this->errorMsg = '';
		$this->warnings = array();
		// $this->log = array("maximum" => array(), "simple" => array());
		$this->totalWebLists = 0;
		$this->webListsImported = 0;

		$res = array('success' => false, 'products' => array(), 'term' => array());

		// Options connexion à Bridge
		$urlBridge = $this->clientParams->getBridgeUrl();
		$siteId = $this->clientParams->getSiteBridge();

		if (empty($urlBridge)) {
			$this->errorMsg = 'URL Bridge indéfinie - contrôlez les paramètres';
			$this->setLog('Erreur - URL Bridge indéfinie');
			return false;
		}

		if ($webListId === null) {
			$this->setLog("Récupération des listes ($langUpper)");
		}

		$time = microtime(true);
		// JM 22/03/2022 : on change le nom du paramètre (update -> v2), moins risqué
		$urlImport = $urlBridge . "/weblist/getForImport?v2=1";

		// si on ne veut importer qu'une seule liste
		if (!empty($webListId)) {
			$urlImport .= "&id=" . $webListId;
		} elseif (!empty($siteId)) {
			// si un site est enregistré, on n'importe que les listes qui lui sont associées
			$urlImport = $urlImport . '&site=' . $siteId;
		}

		if ($this->tmpDebug) {
			$this->setLog("URL : " . $urlImport);
		}

		$data = array();
		$tmpData = file_get_contents($urlImport);
		if (!empty($tmpData)) {
			$tmpDataDecoded = json_decode($tmpData);
			if ($tmpDataDecoded->success) {
				$data = $tmpDataDecoded->data;
			} else {
				$this->errorMsg = $tmpDataDecoded->message;
				return false;
			}
		} else {
			$this->errorMsg = "ERREUR : Échec de l'import de listes depuis l'URL " . $urlImport;
			return false;
		}
		$time2 = microtime(true);
		$this->debugTimeBridgeCalls += ($time2 - $time) ;

		if (!empty($data) && is_array($data)) {
			$this->totalWebLists = count($data);
			// Ce tableau servira à la fin pour supprimer les posts SIT qui ne sont plus dans les flux WebList
			// ND 27/08/22 : ça ne semble plus servir à rien ce truc
			$tabPostID = array();
			$tabImportedProducts = array();
			$counterAllProducts = 0;

			// Ce tableau servira à affecter tous les terms de chaque post à la fin (nécessité d'avoir tout parcouru avant)
			$tabTerms = array();
			// On parcourt les WebList
			foreach ($data as $webList) {
				$this->setLog("Import de la liste $webList->slug");
				$slug = $webList->slug;
				if ($language != 'fr' && empty($webList->slugTranslation->$langUpper)) {
					continue;
				} elseif ($language != 'fr') {
					$slug = $webList->slugTranslation->$langUpper;
					$title = $webList->titleTranslations->$langUpper;
				} elseif ($language == 'fr') {
					$title = $webList->title;
				}
				if (empty($slug) && !empty($title)) {
					$this->errorMsg = "Erreur 2 : Slug vide dans la liste n°" . $webList->id . " (" . $language . ")";
					return false;
				}
				if (empty($title) && empty($slug)) {
					return 'skip';
				}

				$term = $this->clientContentService->getTermFromListId($webList->id, $language);
				$res['term'] = $term;

				$time = microtime(true);

				// Maintenant on insère les posts et on les rattache au term ( $term['term_id'] de la taxonomie $term['term_taxonomy_id'])
				// JM 22/03/2022 : on change le nom du paramètre (update -> v2), moins risqué
				$urlImport = $urlBridge . "/weblist/getProductsForImport/" . $webList->id . '?language=' . $language . '&v2=1';

				$webList = new \stdClass();
				$this->setLog($urlImport);
				$tmpWebList = file_get_contents($urlImport);
				$time2 = microtime(true);
				$this->debugTimeBridgeCalls += ($time2 - $time) ;

				if (!empty($tmpWebList)) {
					$tmpWebListDecoded = json_decode($tmpWebList);
					if ($tmpWebListDecoded->success) {
						$webList = $tmpWebListDecoded->data;
					} else {
						$this->errorMsg = $tmpWebListDecoded->message;
						return false;
					}
				} else {
					$this->errorMsg = "ERREUR : Échec de l'import des listes depuis l'URL " . $urlImport;
					return false;
				}

				if ($this->tmpDebug) {
					$this->setLog("WEBLIST urlImport : $urlImport");
				}

				if (!empty($webList) && is_object($webList)) {
					if (isset($webList->selection)
						&& isset($webList->selection->results)
						&& isset($webList->selection->results->products)
						&& is_array($webList->selection->results->products)
						&& count($webList->selection->results->products) > 0) {

						$products = $webList->selection->results->products;
						foreach ($products as $product) {
							if ($this->isCmdLine) {
								// Pas la peine de passer plusieurs fois sur la même fiche
								if (!in_array($product->productCode, $tabImportedProducts)) {
									$tabImportedProducts[] = $product->productCode;
									// Quand on fait un import en ligne de commande, c'est OK, on lance direct l'import de la fiche
									$this->importPostByProductCodeAndLanguage($product, $language, $term);
								}
								if($counterAllProducts % 50 == 0 && $counterAllProducts > 0) {
									$this->setLog($counterAllProducts . ' fiches importées');
								}
								$counterAllProducts++;
							} else {
								// Quand on fait un import via la page Imports du plug-in, on fragmente en une requête AJAX par fiche (pour éviter timeout si une seule grosse requête) donc ici on ne récupère que les numéros des fiches à importer
								$res['products'][] = (string)$product->productCode;
							}
						}
					} // Fin if resultats dans la WebList
				} else {
					$this->errorMsg = 'La liste est vide';
					$this->setLog('La liste est vide');
					return false;
				} // Fin isset(webList)
				$this->webListsImported++;
			} // Fin Foreach WebList

			// Maintenant, on va affecter les terms aux posts selon le tableau construit auparavant
			// On  en profite pour repérer les fiches qui n'ont pas de catégorie primaiure avec URL canonique

			// NE FAIRE QUE LORS D'UN IMPORT COMPLET DE TOUTES LES WEBLIST SINON ON GENERE DES 404
			// Patch Nicolas 22/10/2021 : la suppression des fiches obsolètes est faite dans la fonction updatePostCategories appelée dans updateRewriteRules
			if ($webListId === null) {
				$this->setLog("Affectation des rubriques aux fiches");
				$res = $this->updateRewriteRules($this->isCmdLine);
				if (!$res) {
					$this->errorMsg = 'Erreur lors de la mise à jour des règles de réécriture';
					return false;
				}
//                $this->setLog("Enregistrement des règles de réécriture d'URL ($langUpper) => ✅");
//                $this->setLog("Suppression des fiches obsolètes ($langUpper) => ✅");
			}

		} else {
			$this->errorMsg = 'Aucune liste à importer - Bridge est peut-être inaccessible - Code 3';
			return false;
		}

		if ($webListId === null) {
			$this->setLog("Fin de l'import $langUpper");
		}
		if ($this->isCmdLine) {
			return true;
		} else {
			$res['success'] = true;

			return $res;
		}
	}

	/**
	 * Cette fonction met à jour les catégories de tous les posts selon les weblists de Bridge
	 * Elle met également à jour les règles de réécriture d'URL
	 * Et elle supprime les posts de type fiche-sit qui n'existent plus dans Bridge
	 * @return bool
	 */
	function updateRewriteRules($isCmdLine = false, $blogId = null, $lang = null)
	{
		if(!empty($lang)) {
			$this->currentForcedLang = $lang;
		}

		$this->isCmdLine = $isCmdLine;

		// Si on n'est pas en ligne de commande, on commence par affecter les catégories à tous les posts à partir d'un flux Bridge (sinon on le fait dans une requête séparée)
		if ($this->isCmdLine) {
			$this->setLog("Mise à jour des rubriques");
			$tmp = $this->update_lists_from_bridge();
			if (!$tmp) {
				$this->setLog("La mise a jour des catégories à échoué - arrêt.");
				return false;
			}
			$this->setLog("Affectation des posts aux rubriques");
			$tmp = $this->updatePostCategories($this->isCmdLine);
			if (!$tmp) {
				$this->setLog("Echec de l'affectation des posts aux rubriques");
				return false;
			}
		}
		// flush_rewrite_rules();
		$this->setLog('UpdateRewriterules terminé');

		return true;
	}

	public function majLiensTrads($isCmdLine = false)
	{

	}

	/**
	 * Importe chaque produit et données associées, dont la catégorie
	 * @param mixed productToImport si isCmdLine = false : product est le productCode a importer
	 * @return bool
	 */
	function importPostByProductCodeAndLanguage($productToImport, $language, $term)
	{
		// Pour éviter d'importer plusieurs fois la même fiche en ligne de commande
		if(is_array($this->alreadyImportedProducts) && isset($this->alreadyImportedProducts[$language]) && in_array($this->isCmdLine ? $productToImport->productCode : $productToImport, $this->alreadyImportedProducts[$language])) {
			return true;
		}

		// Ce tableau servira à la fin pour supprimer les posts SIT qui ne sont plus dans les flux WebList
		$tabPostID = array();
		// Ce tableau servira à affecter tous les terms de chaque post à la fin (nécessité d'avoir tout parcouru avant)
		$tabTerms = array();

		$urlBridge = $this->clientParams->getBridgeUrl();

		if (empty($urlBridge)) {
			$this->errorMsg = 'URL Bridge indéfinie - contrôlez les paramètres';
			return false;
		}

		$product = null;
		$importerImages = false;

		// si on est sur un appel ajax, $productToImport est un simple productCode => on importe les fiches une par une
		if(!$this->isCmdLine) {
			$urlImport = $urlBridge . "/product/getOneProductForImport?code=" . $productToImport . "&language=" . $language;

			$data = new \stdClass();
			$time = microtime(true);
			$tmpData = file_get_contents($urlImport);
			$time2 = microtime(true);
			$this->debugTimeBridgeCalls += ($time2 - $time) ;
			if (!empty($tmpData)) {
				$tmpDataDecoded = json_decode($tmpData);
				if ($tmpDataDecoded->success) {
					$data = $tmpDataDecoded->data;
				} else {
					$this->errorMsg = $tmpDataDecoded->message;
					return false;
				}
			} else {
				// ND 01.11.2022 : on tolère que Brudge renvoit un fux vie pour une fiche, ça peut arriver dans certains cas rares.
				return true;
			}
			if (!empty($data) && isset($data->product) && is_object($data->product)) {
				$product = $data->product;
			}
		} else {
			// si on est en ligne de commande, $productToImport est déjà un object => pas besoin de réimporter 1 by 1
			$product = $productToImport;
		}

		if (!empty($product)) {
			$time = microtime(true);

			if(empty($product->name) || empty($product->slug)) {
				// ND 24.10.2022 : des fiches en anglais de l'OTSR n'ont pas de nom, on tolère mais on ne peut les importer
				return true;
			}

			$importerImagesTemp = $importerImages;
			// On cherche d'abord si le produit existe dans la langue
			$postId = $this->clientContentService->getPostIdFromProductCode($product->productCode, $language);

			// S'il n'existe pas on le crée
			if (empty($postId)) {
				$post = $this->clientContentService->createPostFromBridgeProduct($product, $language);
				if(is_object($post)) {
					$postId = $post->id;
				}
				// $this->bridgeCmsAbstractLayer->setPostLanguage($postId, $language);
			} else {
				// Sinon on le MAJ
				$post = $this->clientContentService->updatePostFromBridgeProduct($postId, $product, $language);
			}
			// Pour éviter d'importer plusieurs fois la même fiche en ligne de commande
			if(is_array($this->alreadyImportedProducts) && isset($this->alreadyImportedProducts[$language]) && is_array($this->alreadyImportedProducts[$language])) {
				$this->alreadyImportedProducts[$language][] = $product->productCode;
			}
			// On ne fait l'import des images qu'en français mais également en langues étrangères si on est dans un multisites
			return true;
		} else {
			if(gettype($productToImport) === "string") {
				$productCode = $productToImport;
			} else {
				$productCode = $productToImport->productCode;
			}
			if (empty($data)) {
				$this->errorMsg = 'Erreur : aucun produit ' . $productCode . 'à importer';
				return false;
			} else {
				$this->errorMsg = "Erreur à l'importation du produit" . $productCode;
				return false;
			}
		}
	}

	public function deleteObsoletePosts($langs, $product_code)
	{
		foreach ($langs as $lang => $postId) {
			// Patch 01.11.22 : on a des meta avec post_id à 0 : on les passe pour éviter de supprimer des attachments qui n'ont rien à voir
			if((string) $postId == "0") {
				return true;
			}

			$langUpper = strtoupper($lang);

			// Suppression du post
			$res = $this->clientContentService->deletePost($postId);
			if ($res == null || $res === false) {
				$bonus = var_export($langs, true);
				$this->setLog("ERREUR lors de la suppression du post n°$postId ($langUpper), fiche Bridge n°$product_code - langs : $bonus");
				$this->errorMsg = "ERREUR lors de la suppression du post n°$postId ($langUpper), fiche Bridge n°$product_code - langs : $bonus";
				return false;
			} else {
				$this->setLog("Suppression du post n°$postId ($langUpper), fiche Bridge n°$product_code");
			}
		}

		return true;
	}

	public function getErrorMsg()
	{
		return $this->errorMsg;
	}

	public function getWarnings()
	{
		return $this->warnings;
	}

	public function getCurrentLog()
	{
		return $this->log;
	}

	function get_http_response_code($url)
	{

	}

}
