<?php

namespace Bridge\Weblibs\Wordpress;

use Bridge\Weblibs\BridgeRequestServiceInterface;
use Bridge\Weblibs\BridgeClientParamsInterface;

class BridgeRequestServiceWordpress implements BridgeRequestServiceInterface
{
    public function cachedFileGetContent( $url, $use_include_path = false, $options = null, $cacheTimeMinutes = 120) {

        $bridgeOptions = get_option('reglages_sit_design_option');

        $cachePath = WP_CONTENT_DIR . '/cache';
        if(!file_exists($cachePath)) { mkdir($cachePath); }
        $cachePath .= '/bridge_cache';
        if(!file_exists($cachePath)) { mkdir($cachePath); }

        $context = null;
        $hashStr = $url . $use_include_path;
        if(!empty($options)) {
            $hashStr .= json_encode($options);
            $context = stream_context_create($options);
        }
        $hash = hash('md5', $url);
        $cacheKey = 'bridge_request_' . $hash;

        if(isset($_REQUEST['dncdebug']) && $_REQUEST['dncdebug'] == 'CACHE') {
            echo "cacheKey : $cacheKey \n";
        }
		$data = $this->getCachedData($cacheKey);
        if(empty($data)) {
            if(isset($_REQUEST['dncdebug']) && $_REQUEST['dncdebug'] == 'CACHE') {
                echo "RIEN EN CACHE, ON RECUP URL $url \n";
            }
	        $raw = @file_get_contents($url, $use_include_path, $context);
	        // Pas de mise en cache si pas de données récupérées (erreur)
	        if($raw !== false) {
				$this->storeCachedData($cacheKey, $raw);
	        }
	        return $raw;
        }
        return $data;
    }

	public function get($paramName, $default = null)
	{
		$param = $default;
		if(isset($_REQUEST[$paramName])) {
			$param = $_REQUEST[$paramName];
		}
		return $param;
	}

	public function getUrlLastModifiedTimestamp($fileUrl) {
		$headers = @get_headers($fileUrl);
		$lmText = '';
		if(isset($headers['Last-Modified']) && !empty($headers['Last-Modified'])) {
			$lmText = $headers['Last-Modified'];
		} elseif(is_array($headers) && count($headers) > 0) {
			foreach($headers as $idx => $header) {
				if(strpos($header, 'Last-Modified:') !== false) {
					$lmText = trim(substr($header, 14));
				}
			}
		}
		$lmDate = new \DateTime();
		if(!empty($lmText)) {
			$lmDate = new \DateTime($lmText);
		}
		if($lmDate === false) {
			$lmDate = new \DateTime();
		}

		$lmTs = $lmDate->format('U');
		return $lmTs;
	}



	public function getHashFromRequestParameters() {
		return $this->getHashFromObjectOrArray($_REQUEST);
	}

	public function getHashFromObjectOrArray($objectOrArray = null) {
		$hash = '';
		if(isset($objectOrArray) && (is_object($objectOrArray) || is_array($objectOrArray))) {
			$hash = hash('md5', json_encode($objectOrArray));
		}
		return $hash;
	}

	public function getCachedData($cacheKey, $cacheTimeMinutes = 60 * 24 * 30, $unSerialize = false) {
		$ret = null;

		$bridgeOptions = get_option('reglages_sit_design_option');

		$cachePath = WP_CONTENT_DIR . '/cache';
		if(!file_exists($cachePath)) { mkdir($cachePath); }
		$cachePath .= '/bridge_cache';
		if(!file_exists($cachePath)) { mkdir($cachePath); }

		$cacheFile = $cachePath . '/' . $cacheKey . '.txt';

		// Par défaut on utilise le cache !
		$useCache = true;
		if(isset($bridgeOptions['use_bridge_cache']) && $bridgeOptions['use_bridge_cache'] === 'disabled') {
			$useCache = false;
		}

		if(isset($bridgeOptions['bridge_cache_duration_minutes']) && !empty(isset($bridgeOptions['bridge_cache_duration_minutes']))) {
			$cacheTimeMinutes = (int) $bridgeOptions['bridge_cache_duration_minutes'];
			if($cacheTimeMinutes < 1) {
				$cacheTimeMinutes = 5;
			}
		}
		$cacheTime = $cacheTimeMinutes * 60 ; // Secondes

		// Pas de cache pour les utilisateurs connectés => on ne cache que pour les visiteurs
		$is_connected = is_user_logged_in();
		if($useCache && !$is_connected && file_exists($cacheFile) && (time() - filemtime($cacheFile) < $cacheTime)) {
			$resCache = @file_get_contents($cacheFile);
			if(!empty($resCache)) {
                if($unSerialize) {
                    $resCache = @unserialize($resCache);
                }
                if(isset($_REQUEST['dncdebug']) && $_REQUEST['dncdebug'] == 'CACHE') {
                    echo "IL Y A DES DONNEES EN CACHE pour la clé $cacheKey : \n";
                    echo "<pre>\n";
                    print_r($resCache);
                    echo "\n</pre>\n";
                }

                return $resCache;
			}
		} else {
            if(isset($_REQUEST['dncdebug']) && $_REQUEST['dncdebug'] == 'CACHE') {
                echo "PAS DE DONNEES EN CACHE pour la clé $cacheKey : \n";
            }
        }
		return $ret;
	}

	public function storeCachedData($cacheKey, $data, $serialize = false) {
		$bridgeOptions = get_option('reglages_sit_design_option');

		$cachePath = WP_CONTENT_DIR . '/cache';
		if(!file_exists($cachePath)) { mkdir($cachePath); }
		$cachePath .= '/bridge_cache';
		if(!file_exists($cachePath)) { mkdir($cachePath); }

		$cacheFile = $cachePath . '/' . $cacheKey . '.txt';

		// Par défaut on utilise le cache !
		$useCache = true;
		if(isset($bridgeOptions['use_bridge_cache']) && $bridgeOptions['use_bridge_cache'] === 'disabled') {
			$useCache = false;
		}
		if($useCache) {
            if($serialize) {
                $data = serialize($data);
            }
			@file_put_contents($cacheFile, $data);
		}
		return true;
	}
}


