<?php

namespace Drupal\pylot_bridge\Controller;

use Drupal\Component\Serialization\Json;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Drupal\Core\StringTranslation\TranslationInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\Cache\CacheableMetadata;

use Bridge\Weblibs\BridgeImageService;
use Bridge\Weblibs\BridgeDataGetter;
use Bridge\Weblibs\BridgeClientParamsInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;


/**
 * Class ImportController.
 */
class FrontendController extends ControllerBase
{
    use StringTranslationTrait;

    public function __construct(
        private readonly BridgeImageService $bridgeImageService,
        private readonly BridgeDataGetter $bridgeDataGetter,
        private readonly BridgeClientParamsInterface $bridgeClientParams,
        TranslationInterface $string_translation,
    ) {
        // Alimente le trait StringTranslationTrait proprement
        $this->stringTranslation = $string_translation;
    }

    public static function create(ContainerInterface $container): self {
        return new self(
            $container->get(BridgeImageService::class),        // BridgeImageService injecté
            $container->get(BridgeDataGetter::class),        // BridgeDataGetterService injecté
            $container->get(BridgeClientParamsInterface::class),        // BridgeDataGetterService injecté
            $container->get('string_translation'),             // string_translation injecté
        );
    }

    /**
     * Redimensionneur dynamique d'images
     * @return string|void
     */
    public function resize_image()
    {
        $timeToCache = 1800 ; // Durée de cache navigateur

        /* retourne les données brutes d'une image redimensionnée
          $file : URL de la photo originale
          $mode : mode de redimensonnement :
          - ajust pour ajuster aux dimensions passées (ne déborde pas)
          - remplir : pour remplir le cadre de dimensions passées
          - deform : pour déformer l'image et forcer les dimensions exactes
          $selwidth : largeur souhaitée
          $selheight : hauteur souhaitée
          $timeToCache : durée du cache navigateur renvoyé dans les entêtes http
         */

        $file = "";
        $mode = "";
        $selwidth = "";
        $selheight = "";
        $def = 60;
        $quality = 60;
        $debug = false;

        if (array_key_exists('timeToCache', $_REQUEST))
            $timeToCache = (int) $_REQUEST['timeToCache'];
        if (array_key_exists('file', $_REQUEST))
            $file = $_REQUEST['file'];
        if (array_key_exists('mode', $_REQUEST))
            $mode = $_REQUEST['mode'];
        if (array_key_exists('selwidth', $_REQUEST))
            $selwidth = $_REQUEST['selwidth'];
        if (array_key_exists('selheight', $_REQUEST))
            $selheight = $_REQUEST['selheight'];
        if (array_key_exists('quality', $_REQUEST))
            $quality = $_REQUEST['quality'];
        if (array_key_exists('debug', $_REQUEST))
            $debug = ($_REQUEST['dncdebug'] == 'Y');


        if ($mode == "")
            $mode = "ajust";
        if ($selwidth == "" && $selheight == "")
            $selwidth = "100";

        $res = $this->bridgeImageService->resizeImage($file, $mode, $selwidth, $selheight, $quality, $debug);

        return new Response ($res['data'], 200, $res['headers']);

    }


    /**
     * Récupération des POI à mettre sur la carte à côté de la liste
     */
    public function listeAjaxCities()
    {
        // On crée un tableau d'attributs pour l'affichage Ajax
        $attributes = array();
        $attributes['max'] = 900;
        if(isset($_REQUEST['max'])) {
            $attributes['max'] = $_REQUEST['max'];
        }
        $attributes['id'] = '';
        if(isset($_REQUEST['id'])) {
            $attributes['id'] = $_REQUEST['id'];
        }
        $attributes['product_codes'] = '';
        if(isset($_REQUEST['product_codes'])) {
            $attributes['product_codes'] = $_REQUEST['product_codes'];
        }

        // Ajout 13/02/2023 :  possibilité de passer un nom de commune pour cumulr un filtre par commune à la séelction de la liste
        if (isset($_REQUEST['filter_city']))
            $attributes['filter_city'] = $_REQUEST['filter_city'];
        if (isset($_REQUEST['filter_criterions']))
            $attributes['filter_criterions'] = $_REQUEST['filter_criterions'];
        if (isset($_REQUEST['scoring']))
            $attributes['scoring'] = $_REQUEST['scoring'];
        if (isset($_REQUEST['filter_lat']))
            $attributes['filter_lat'] = $_REQUEST['filter_lat'];
        if (isset($_REQUEST['filter_lon']))
            $attributes['filter_lon'] = $_REQUEST['filter_lon'];
        if (isset($_REQUEST['filter_rayon']))
            $attributes['filter_rayon'] = $_REQUEST['filter_rayon'];
        if (isset($_REQUEST['selection_id']))
            $attributes['selection_id'] = $_REQUEST['selection_id'];
        if (isset($_REQUEST['excluded_codes']))
            $attributes['excluded_codes'] = $_REQUEST['excluded_codes'];
        if (isset($_REQUEST['sort_one']))
            $attributes['sort_one'] = $_REQUEST['sort_one'];
        if (isset($_REQUEST['sort_two']))
            $attributes['sort_two'] = $_REQUEST['sort_two'];
        if (isset($_REQUEST['sort_three']))
            $attributes['sort_three'] = $_REQUEST['sort_three'];
        if (isset($_REQUEST['duplicate_by']))
            $attributes['duplicate_by'] = $_REQUEST['duplicate_by'];
        if (isset($_REQUEST['filter_id']))
            $attributes['filter_id'] = $_REQUEST['filter_id'];


        $get_as_label_array = '';
        if(isset($_REQUEST['get_as_label_array'])) {
            $get_as_label_array = $_REQUEST['get_as_label_array'];
        }

        $res = array(
            'success' => false,
            'max' => $attributes['max'],
            'total' => null,
            'message' => '',
            'data' => null
        );

        try {
            // $dataReturned =  BridgeUtils::getCitiesData($attributes, true);
            $dataReturned = $this->bridgeDataGetter->getCitiesData($attributes, true);
        } catch (\Exception $e) {
            $res['message'] = 'Une erreur est survenue : ' . $e->getMessage();
            return new JsonResponse($res);
        }

        // $lang = BridgeUtils::getLanguage();
        if (empty($dataReturned) || !isset($dataReturned['success']) || !isset($dataReturned['data'])) {
            if (!empty($get_as_label_array)) {
                $res = array();
            } else {
                $res['success'] = true;
                $res['data'] = array();
            }
            return new JsonResponse($res);
        }

        // si erreur
        if ($dataReturned['success'] === false) {
            $res['message'] = $dataReturned['message'];
            return new JsonResponse($res);
        }

        if (!empty($get_as_label_array)) {
            $res = array();
            for($i = 0 ; $i < count($dataReturned['data']) ; $i++) {
                $res[] = (object) array('label' => $dataReturned['data'][$i]->city, 'lat' => $dataReturned['data'][$i]->latitude, 'lon' => $dataReturned['data'][$i]->longitude);
            }
        } else {
            $res['success'] = true;
            $res['data'] = $dataReturned['data'];
        }
        return new JsonResponse($res);
    }

    /**
     * liste ajax pour infinite scroll
     */
    public function listeAjaxInfinite()
    {

        // On crée un tableau d'attributs pour l'affichage Ajax
        $attributes = array();
        if (isset($_REQUEST['id']))
            $attributes['id'] = $_REQUEST['id'];
        if (isset($_REQUEST['product_codes']))
            $attributes['product_codes'] = $_REQUEST['product_codes'];
        if (isset($_REQUEST['max']))
            $attributes['max'] = $_REQUEST['max'];
        else
            $attributes['max'] = '';
        if (isset($_REQUEST['first']))
            $attributes['first'] = $_REQUEST['first'];
        if (isset($_REQUEST['itemTemplate']))
            $attributes['item_template'] = $_REQUEST['itemTemplate'];
        if (isset($_REQUEST['item_template']))
            $attributes['item_template'] = $_REQUEST['item_template'];
        if (isset($_REQUEST['change']))
            $attributes['change'] = $_REQUEST['change'];
        if (isset($_REQUEST['minimal_select']))
            $attributes['minimal_select'] = $_REQUEST['minimal_select'];
        // Ajout 13/02/2023 :  possibilité de passer un nom de commune pour cumulr un filtre par commune à la séelction de la liste
        if (isset($_REQUEST['filter_city']))
            $attributes['filter_city'] = $_REQUEST['filter_city'];
        if (isset($_REQUEST['filter_criterions']))
            $attributes['filter_criterions'] = $_REQUEST['filter_criterions'];
        if (isset($_REQUEST['scoring']))
            $attributes['scoring'] = $_REQUEST['scoring'];
        if (isset($_REQUEST['filter_lat']))
            $attributes['filter_lat'] = $_REQUEST['filter_lat'];
        if (isset($_REQUEST['filter_lon']))
            $attributes['filter_lon'] = $_REQUEST['filter_lon'];
        if (isset($_REQUEST['filter_rayon']))
            $attributes['filter_rayon'] = $_REQUEST['filter_rayon'];
        if (isset($_REQUEST['selection_id']))
            $attributes['selection_id'] = $_REQUEST['selection_id'];
        if (isset($_REQUEST['excluded_codes']))
            $attributes['excluded_codes'] = $_REQUEST['excluded_codes'];
        if (isset($_REQUEST['sort_one']))
            $attributes['sort_one'] = $_REQUEST['sort_one'];
        if (isset($_REQUEST['sort_two']))
            $attributes['sort_two'] = $_REQUEST['sort_two'];
        if (isset($_REQUEST['sort_three']))
            $attributes['sort_three'] = $_REQUEST['sort_three'];
        if (isset($_REQUEST['duplicate_by']))
            $attributes['duplicate_by'] = $_REQUEST['duplicate_by'];

        try {
            $preData = $this->bridgeDataGetter->getListData($attributes);
            // $dataReturned = BridgeUtils::getListData($attributes, true);
        } catch(\Exception $e) {
            return new Response('Une erreur est survenue : ' . $e->getMessage());
        }

        ob_start();
        // $preData = BridgeUtils::getListData($attributes);
        // $data = BridgeUtils::prepareListDataForRender($preData);
        $data = $this->bridgeDataGetter->prepareListDataForRender($preData);
        $build = array(
            '#theme' => 'liste_sit',
            '#attached' => array('library' => array()),
            '#children' => array(),
            '#listInfos' => $data['listInfos'],
            '#listParameters' => $data['listParameters'],
            '#data' => $data['data'],
            '#moteur' => $data['moteur'],
            '#bridgeParameters' => $data['bridgeParameters'],
            '#pageTitle' => $data['pageTitle'],
            '#pageDescription' => $data['pageDescription'],
        );
        $html = \Drupal::service('renderer')->renderPlain($build);
        return new Response($html);
    }

    /**
     * Récupération dynamique de données Bridge pour affichage en liste
     * @return JsonResponse
     */
    public function list_products_json() {

        if (isset($_REQUEST['action'])) {
            $action = $_REQUEST['action'];
            if ($action == 'brListCities') {
                return $this->listeAjaxCities();
            }
        }
        // On crée un tableau d'attributs pour l'affichage Ajax
        $attributes = array();
        if (isset($_REQUEST['id']))
            $attributes['id'] = $_REQUEST['id'];
        if (isset($_REQUEST['max']))
            $attributes['max'] = $_REQUEST['max'];
        else
            $attributes['max'] = '';
        if (isset($_REQUEST['first']))
            $attributes['first'] = $_REQUEST['first'];
        if (isset($_REQUEST['change']))
            $attributes['change'] = $_REQUEST['change'];

        if (isset($_REQUEST['itemTemplate']))
            $attributes['item_template'] = $_REQUEST['itemTemplate'];
        if (isset($_REQUEST['item_template']))
            $attributes['item_template'] = $_REQUEST['item_template'];

        $attributes['product_codes'] = '';
        if(isset($_REQUEST['product_codes'])) {
            $attributes['product_codes'] = $_REQUEST['product_codes'];
        }
        // Ajout 13/02/2023 :  possibilité de passer un nom de commune pour cumulr un filtre par commune à la séelction de la liste
        if (isset($_REQUEST['filter_city']))
            $attributes['filter_city'] = $_REQUEST['filter_city'];
        if (isset($_REQUEST['filter_criterions']))
            $attributes['filter_criterions'] = $_REQUEST['filter_criterions'];
        if (isset($_REQUEST['scoring']))
            $attributes['scoring'] = $_REQUEST['scoring'];
        if (isset($_REQUEST['filter_lat']))
            $attributes['filter_lat'] = $_REQUEST['filter_lat'];
        if (isset($_REQUEST['filter_lon']))
            $attributes['filter_lon'] = $_REQUEST['filter_lon'];
        if (isset($_REQUEST['filter_rayon']))
            $attributes['filter_rayon'] = $_REQUEST['filter_rayon'];
        if (isset($_REQUEST['selection_id']))
            $attributes['selection_id'] = $_REQUEST['selection_id'];
        if (isset($_REQUEST['excluded_codes']))
            $attributes['excluded_codes'] = $_REQUEST['excluded_codes'];
        if (isset($_REQUEST['sort_one']))
            $attributes['sort_one'] = $_REQUEST['sort_one'];
        if (isset($_REQUEST['sort_two']))
            $attributes['sort_two'] = $_REQUEST['sort_two'];
        if (isset($_REQUEST['sort_three']))
            $attributes['sort_three'] = $_REQUEST['sort_three'];
        if (isset($_REQUEST['duplicate_by']))
            $attributes['duplicate_by'] = $_REQUEST['duplicate_by'];

        $res = array(
            'max' => $attributes['max'],
            'total' => null,
            'message' => '',
            'html' => ''
        );

        try {
            $dataReturned = $this->bridgeDataGetter->getListData($attributes, true);
        } catch(\Exception $e) {
            $res['message'] = 'Une erreur est survenue : ' . $e->getMessage();
            return new JsonResponse($res);
        }

        // $lang = BridgeUtils::getLanguage();
        if (empty($dataReturned) || !isset($dataReturned['success']) || !isset($dataReturned['message']) || !isset($dataReturned['total'])) {
            if(isset($dataReturned['message']))
                $res['message'] = $dataReturned['message'];
            else
                $res['message'] = 'Une erreur est survenue';
            return new JsonResponse($res);
        }

        // si erreur
        if ($dataReturned['success'] === false) {
            $res['message'] = $dataReturned['message'];
            return new JsonResponse($res);
        }
        // si success mais aucun résultat
        if ($dataReturned['total'] === 0) {
            $res['total'] = $dataReturned['total'];
            $res['message'] = $dataReturned['message'];
            return new JsonResponse($res);
        }

        $html = '';
        // On charge l'HTML des vignettes uniquement
        if (isset($_REQUEST['itemTemplate']) && !empty($_REQUEST['itemTemplate'])) {
            $attributes['itemTemplate'] = $_REQUEST['itemTemplate'];
        }

        $moteurObj = $dataReturned['data']->moteur;

        try {
            // On récupère les données prêtes à être passées à la vue
            $data = $this->bridgeDataGetter->prepareListDataForRender($dataReturned);

            $build = array(
                '#theme' => 'liste_sit_ajax',
                '#attached' => array('library' => array()),
                '#children' => array(),
                '#listInfos' => $data['listInfos'],
                '#listParameters' => $data['listParameters'],
                '#data' => $data['data'],
                '#moteur' => $data['moteur'],
                '#bridgeParameters' => $data['bridgeParameters'],
                '#pageTitle' => $data['pageTitle'],
                '#pageDescription' => $data['pageDescription'],
            );
            $html = \Drupal::service('renderer')->renderPlain($build);

            $res['total'] = $dataReturned['total'];
            $res['html'] = $html;
            $res['moteur'] = $moteurObj;
            // $res['lang'] = $lang;

            if (isset($data['listInfos']->cityComboDynList)) {
                $res['cityComboDynList'] = $data['listInfos']->cityComboDynList;
            } else {
                $res['cityComboDynList'] = "0";
            }
            if (isset($data['listInfos']->lastPage)) {
                $res['lastPage'] = $data['listInfos']->lastPage;
            }
        } catch (\Exception $e) {
            $res['message'] = 'Erreur 09 : ' . $e->getMessage();
            return new JsonResponse($res);
        }

        return new JsonResponse($res);
    }

    /**
     * Récupération dynamique de données Bridge pour affichage des points sur la carte
     * @return JsonResponse
     */
    public function list_products_json_for_map_poi() {

        // On crée un tableau d'attributs pour l'affichage Ajax
        $attributes = array();
        if (isset($_REQUEST['id']))
            $attributes['id'] = $_REQUEST['id'];
        if (isset($_REQUEST['max']))
            $attributes['max'] = $_REQUEST['max'];
        else
            $attributes['max'] = '';
        if (isset($_REQUEST['first']))
            $attributes['first'] = $_REQUEST['first'];

        if (isset($_REQUEST['change']))
            $attributes['change'] = $_REQUEST['change'];

        // Pour réduire le nombre de champs retournés par bridge
        $attributes['minimal_select'] = '1';

        $attributes['product_codes'] = '';
        if(isset($_REQUEST['product_codes'])) {
            $attributes['product_codes'] = $_REQUEST['product_codes'];
        }
        // Ajout 13/02/2023 :  possibilité de passer un nom de commune pour cumulr un filtre par commune à la séelction de la liste
        if (isset($_REQUEST['filter_city']))
            $attributes['filter_city'] = $_REQUEST['filter_city'];
        if (isset($_REQUEST['filter_criterions']))
            $attributes['filter_criterions'] = $_REQUEST['filter_criterions'];
        if (isset($_REQUEST['scoring']))
            $attributes['scoring'] = $_REQUEST['scoring'];
        if (isset($_REQUEST['filter_lat']))
            $attributes['filter_lat'] = $_REQUEST['filter_lat'];
        if (isset($_REQUEST['filter_lon']))
            $attributes['filter_lon'] = $_REQUEST['filter_lon'];
        if (isset($_REQUEST['filter_rayon']))
            $attributes['filter_rayon'] = $_REQUEST['filter_rayon'];
        if (isset($_REQUEST['selection_id']))
            $attributes['selection_id'] = $_REQUEST['selection_id'];
        if (isset($_REQUEST['excluded_codes']))
            $attributes['excluded_codes'] = $_REQUEST['excluded_codes'];
        if (isset($_REQUEST['sort_one']))
            $attributes['sort_one'] = $_REQUEST['sort_one'];
        if (isset($_REQUEST['sort_two']))
            $attributes['sort_two'] = $_REQUEST['sort_two'];
        if (isset($_REQUEST['sort_three']))
            $attributes['sort_three'] = $_REQUEST['sort_three'];
        if (isset($_REQUEST['duplicate_by']))
            $attributes['duplicate_by'] = $_REQUEST['duplicate_by'];


        $res = array(
            'success' => false,
            'max' => $attributes['max'],
            'total' => null,
            'message' => '',
            'data' => null
        );

        try {
            $dataReturned = $this->bridgeDataGetter->getListData($attributes, true);
        } catch(\Exception $e) {
            $res['message'] = 'Une erreur est survenue : ' . $e->getMessage();
            return new JsonResponse($res);
        }

        // $lang = BridgeUtils::getLanguage();
        if (empty($dataReturned) || !isset($dataReturned['success']) || !isset($dataReturned['message']) || !isset($dataReturned['total'])) {
            if(isset($dataReturned['message']))
                $res['message'] = $dataReturned['message'];
            else
                $res['message'] = 'Une erreur est survenue';
            return new JsonResponse($res);
        }

        // si erreur
        if ($dataReturned['success'] === false) {
            $res['message'] = $dataReturned['message'];
            return new JsonResponse($res);
        }

        $res['success'] = true;
        $res['data'] = $dataReturned['data'];
        return new JsonResponse($res);
    }



    /**
     * bridge_send_email_recaptcha
     * Appelée en ajax sur envoi d'un formulaire de contact dans la fiche : vérifie le token Recaptcha V3 et envoie le mail au prestataire
     */
    public function bridge_send_email_recaptcha() {
        $productcode = $_REQUEST['productCode'];
        $webPageId = $_REQUEST['webPageId'];
        $token = $_REQUEST['token'];
        $name = $_REQUEST['name'];
        $email = $_REQUEST['email'];
        $message = $_REQUEST['message'];
        $subject = $_REQUEST['subject'];
        $dest = $_REQUEST['dest'];

        $res = array('success' => false, 'data' => '');

        // On vérifie que l'appel est correct
        if(empty($dest) || empty($productcode) || empty($webPageId) || empty($name) || empty($email) || empty($message) || empty($token) || empty($subject) ) {
            $res['data'] = 'Erreur : appel incorrect';
            return new JsonResponse($res);
        }

        try {
            // On vérifie le token Recaptcha V3
            $dataFiche = $this->bridgeDataGetter->getDataFiche($productcode, $webPageId);

            $body = '';
            if(!empty($dataFiche->parameters->emailPrestBody ))
                $body = $dataFiche->parameters->emailPrestBody;

            if(empty($body)) {
                $body = "Bonjour, \n\nUne demande de renseignements a été envoyée depuis le site " . get_site_url() ;
            }
            $emailBody = $body . "\n";
            $emailBody .= "\nNom : ". stripcslashes($name) ;
            $emailBody .= "\nEmail : $email";
            $emailBody .= "\nMessage : " . stripcslashes($message);
            if(!empty($dataFiche->parameters->emailPrestBodyEnd ))
                $emailBody .= "\n\n" . $dataFiche->parameters->emailPrestBodyEnd;

            // Vérification recaptcha
            if ($dataFiche->parameters->emailFormAntispam == 'RECAPTCHAV2') {
                $recaptchaSecretKey = $dataFiche->parameters->recaptchav2_secret_key;
                $recaptcha_url = 'https://www.google.com/recaptcha/api/siteverify';
                $recaptcha = file_get_contents($recaptcha_url . '?secret=' . $recaptchaSecretKey . '&response=' . $token);
                $recaptcha = json_decode($recaptcha);
                if($recaptcha->success === true) {
                    $mailManager = \Drupal::service('plugin.manager.mail');
                    $module = 'pylot_bridge';
                    $key = 'email_form';
                    $params = array('subject' => $subject, 'message' => $emailBody, 'reply-to' => stripcslashes($name) . '<' . $email . '>');
                    $langcode = 'fr';
                    $send = true;
                    $result = $mailManager->mail($module, $key, $dest, $langcode, $params, NULL, $send);
                    if ($result['result'] !== true) {
                        $message = $this->t('Erreur lors de l\'envoi de l\'email');
                        $res = array('success' => false, 'data' => $message);
                        return new JsonResponse($res);
                    } else {
                        $res = array('success' => true, 'data' => $this->t('Message envoyé avec succès'));
                        return new JsonResponse($res);
                    }
                } else {
                    $prop = 'error-codes';
                    $message = $this->t('La vérification antispam a échoué');
                    if(isset($recaptcha->$prop) && is_array($recaptcha->$prop)) {
                        $message .= ' ' . implode (' - ', $recaptcha->$prop);
                    }
                    $res = array('success' => false, 'data' => $message);
                    return new JsonResponse($res);
                }
            } elseif ($dataFiche->parameters->emailFormAntispam == 'RECAPTCHAV3') {
                $recaptchaSecretKey = $dataFiche->parameters->recaptchav3_secret_key;
                $recaptcha_url = 'https://www.google.com/recaptcha/api/siteverify';
                $recaptcha = file_get_contents($recaptcha_url . '?secret=' . $recaptchaSecretKey . '&response=' . $token);
                $recaptcha = json_decode($recaptcha);
                // Selon le score recaptcha on envoie le mail ou pas
                if ($recaptcha->score >= 0.5) {
                    $mailManager = \Drupal::service('plugin.manager.mail');
                    $module = 'pylot_bridge';
                    $key = 'email_form';
                    $params = array('subject' => $subject, 'message' => $emailBody, 'reply-to' => stripcslashes($name) . '<' . $email . '>');
                    $langcode = 'fr';
                    $send = true;
                    $result = $mailManager->mail($module, $key, $dest, $langcode, $params, NULL, $send);
                    if ($result['result'] !== true) {
                        $message = $this->t('Erreur lors de l\'envoi de l\'email');
                        $res = array('success' => false, 'data' => $message);
                        return new JsonResponse($res);
                    } else {
                        $res = array('success' => true, 'data' => $this->t('Message envoyé avec succès'));
                        return new JsonResponse($res);
                    }
                } else {
                    $prop = 'error-codes';
                    $message = $this->t('La vérification antispam a échoué');
                    if(isset($recaptcha->$prop) && is_array($recaptcha->$prop)) {
                        $message .= ' ' . implode (' - ', $recaptcha->$prop);
                    }
                    $res = array('success' => false, 'data' => $message);
                    return new JsonResponse($res);
                }
            } else {
                $message = $this->t('Mode de vérification captcha non supporté');
                $res = array('success' => false, 'data' => $message);
                return new JsonResponse($res);
            }

        } catch (\Exception $e) {
            $message = $this->t('Erreur lors de l\'envoi de l\'email');
            $res = array('success' => false, 'data' => $message);
            return new JsonResponse($res);
        }
    }

    /**
     * Fonction proxy pour afficher le widget dispos Avizi depuis le site courant pour éviter les erreurs CORS lors du redimensionement de l'IFRAME
     */
    public function dispos_avizi() {
        if(!isset($_REQUEST['dispos-avizi']))
            return;

        if(!isset($_REQUEST['avizi_entity']) || !isset($_REQUEST['avizi_id']) || !isset($_REQUEST['avizi_lang']) || empty($_REQUEST['avizi_entity']) || empty($_REQUEST['avizi_id']) || $_REQUEST['avizi_lang'] === '') {
            die("appel incorrect");
        }

        die(file_get_contents('https://app.avizi.fr/disponibilites/public/' . $_REQUEST['avizi_entity'] . '/' . $_REQUEST['avizi_id'] .'&consult=a5a5a5&libre=abc638&complet=cc4a4a&fermer=000000&langue=' . $_REQUEST['avizi_lang']));

    }

    /**
     * Téléchargement de la trace d'un itineraire
     * @return JsonResponse
     */
    public function download_trace()
    {
        if (!isset($_REQUEST['product_code']) || empty($_REQUEST['product_code']) || !isset($_REQUEST['trace_format']) || empty($_REQUEST['trace_format']))
            return;
        $product_code = $_REQUEST['product_code'];
        $trace_format = $_REQUEST['trace_format'];
        $method = 'getGpx';
        $ext = 'gpx';
        $mime = 'application/gpx+xml';

        switch ($trace_format) {
            case 'gpx':
                $method = 'getGpx';
                $ext = 'gpx';
                $mime = 'application/gpx+xml';
                break;
            case 'kml':
                $method = 'getKml';
                $ext = 'kml';
                $mime = 'text/xml';
                break;
            case 'geojson':
                $ext = 'json';
                $mime = 'application/geo+json';
                $method = 'getGeoJson';
                break;
        }
        $tmpOptions = $this->bridgeClientParams->getBridgeCredentials(); // BridgeUtils::getBridgeCredentials();
        $urlBridge = $tmpOptions->urlBridge;
        $url = $urlBridge . '/product/' . $method . '/' . $product_code;
        // die($url);
        $data = @file_get_contents($url);
        if(!empty($data)) {
            header('Access-Control-Allow-Origin: *');
            header('Content-Type: ' . $mime);
            header('Content-Disposition: attachment; filename=trace.' . $ext);
            die($data);
        }
    }
}
