<?php

/**
 * @file
 * Contains Drupal\pylot_bridge\Plugin\Filter.
 */

namespace Drupal\pylot_bridge\Plugin\Filter;

use Drupal\filter\FilterProcessResult;
use Drupal\filter\Plugin\FilterBase;
use Bridge\Weblibs\BridgeShortCodeParser;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\pylot_bridge\Services\BridgeUtils;


/**
 * Provides a filter to replace  with code wrappers.
 *
 * @Filter(
 *  id = "bridge_filter",
 *  module = "pylot_bridge",
 *  title = @Translation("Pylot Bridge : shortcodes"),
 *  type = Drupal\filter\Plugin\FilterInterface::TYPE_TRANSFORM_REVERSIBLE,
 *  cache = FALSE,
 *  weight = 0
 * )
 */
class BridgeFilter extends FilterBase {

    private $attachListLibraries = false;
    private $attachFicheLibraries = false;


    /**
     * {@inheritdoc}
     */
    public function process($text, $langcode) {
        $new_text = $text;
        $shortCodeParser = \Drupal::service('pylot_bridge.bridge_shortcode_parser');
        $rendererService = \Drupal::service('pylot_bridge.bridge_client_renderer_service');
        // $data = BridgeShortCodeParser::process($text, $langcode);
        $data = $shortCodeParser->process($text, $langcode);

        // Shortcode [brliste id="XX"]
        $new_text = $data->text;
        $result = new FilterProcessResult($new_text);

        if($data->shortcodeListeMatched) {
            $result->addCacheContexts([
                'url.query_args:braf',
                'url.query_args:brai',
                'url.query_args:brpa',
                'url.query_args:noCache',
            ]);
            $libraries = $rendererService->getListLibraries();
            $result->setAttachments(array(
                'library' => $libraries,
            ));
        }
        if($data->shortcodeFicheMatched) {
            $result->addCacheContexts([
                'url.query_args:id_fiche',
                'url.query_args:noCache',
            ]);
            $libraries = $rendererService->getFicheLibraries();
            $result->setAttachments(array(
                'library' => $libraries,
            ));
        }
        return $result ;
    }




}
