<?php
/**
 * Template d'affichage de sommaire des blocs personnalisés  dans une page fiche détaillée
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche
 *
 * @version 3.3
 *
 */

$blocks = $fiche->ficheBlocks->custom;
$descriptifFilled = false;
if(BridgeBlockService::textBlockIsNotEmpty($fiche, $fiche->ficheBlocks, "descriptif"))
    $descriptifFilled = true;

// Signets pour savoir quand insérer des séparateurs
$previousGroupId = -1;
$previousBlockId = -1;

?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_sommaire') ; ?>
    <div class="sommaire" uk-sticky="offset:20; bottom:#detailfiche">
        <ul class="uk-nav uk-nav-default uk-list-divider" uk-scrollspy-nav="closest: li; scroll: true;cls:uk-text-bold">
    <li><a href="#galerie" uk-scroll><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_GALERIE', 'Galerie','plugin-sit'); ?></a></li>
    <?php if($descriptifFilled): ?>
    <li><a href="#descriptif" uk-scroll><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_DESCRIPTIF', 'Descriptif','plugin-sit'); ?></a></li>
    <?php endif; ?>

	<?php if(count($blocks) > 0) :?>
		<?php foreach($blocks as $blockData) :  ?>
            <?php if(BridgeBlockService::blockIsNotEmpty($fiche, $blockData)): ?>
                <?php $label = $blockData->blockLabel; ?>
                <?php $icon = ''; ?>
                <?php if(!empty($blockData->blockIcon)): ?>
                    <?php $icon = BridgeUtils::renderIcon($blockData->blockIcon); ?>
                <?php endif; ?>
                    <?php // S'il y a un groupe, on le met à la racine ?>
                <?php if (isset($blockData->wpGroup) && is_object($blockData->wpGroup) && (!empty($blockData->wpGroup->label)  || !empty($blockData->wpGroup->wpGroupIcon)) && $previousGroupId != $blockData->wpGroup->id): ?>
                    <?php $label = $blockData->wpGroup->label; ?>
                    <?php $icon = ''; ?>
                    <?php if(!empty($blockData->wpGroupIcon)): ?>
                        <?php $icon = BridgeUtils::renderIcon($blockData->wpGroupIcon); ?>
                    <?php endif; ?>
                    <?php $previousBlockId = -1 ; // Désactive le séparateur de block comme c'est le premier ?>
                <?php elseif(isset($blockData->wpGroup) && is_object($blockData->wpGroup) && !empty($blockData->wpGroup->label)): ?>
                    <?php // Si on est dans un groupe interne à un groupe, on ne met pas d'ancre ?>
                    <?php $label = ''; ?>
                <?php endif; ?>
                <?php if(!empty($label) || !empty($blockData->blockIcon)): ?>
                    <li>
                        <a href="#custom-block-<?= $blockData->blockId ?>" uk-scroll>
                            <?= BridgeUtils::renderIcon($blockData->blockIcon); ?><?= $label ?>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if (isset($blockData->wpGroup) && is_object($blockData->wpGroup) && (!empty($blockData->wpGroup->label)  || !empty($blockData->wpGroup->wpGroupIcon))): ?>
                    <?php $previousGroupId = $blockData->wpGroup->id; ?>
                <?php endif; ?>
			<?php endif; ?>
		<?php endforeach; ?>
	<?php endif; ?>

	<?php
	// Si il y a des fiches associées	: FINI => infos supp 3 et 4 pour le moment on ne gère pas le lien dans le sommaire
	if(false && isset($coupledProducts) && is_array($coupledProducts) && count($coupledProducts) > 0) :?>
		<li><a href="#coupled" uk-scroll><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_A_VOIR_AUSSI', 'A voir aussi', 'plugin-sit') ?></a></li>
	<?php endif; ?>

</ul>
</div>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_sommaire') ; ?>
