<?php
/**
 * Template d'affichage de block dans une page fiche détaillée - bloc coordonnées de fiche 3
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks-fiche3
 *
 * @version 3.3
 *
 */

BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_coordonnees', $ficheData);
if(BridgeBlockService::itemsBlockIsNotEmpty($fiche, $fiche->ficheBlocks, 'coordonnees-contact')): ?>

<li class="coordonnees  <?= (string) $fiche->ficheBlocks->{'coordonnees-contact'}->cssClass ?>" itemprop="address" itemscope itemtype="https://schema.org/PostalAddress">
   <div class="uk-grid uk-flex-middle">
	   <div class="uk-width-1-6 uk-text-center"><i class="fa fa-map-marker fa-3x"></i></div>
	   <div class="uk-width-5-6">
           <?= BridgeBlockService::renderNamedBlockHtml($fiche->ficheBlocks, 'coordonnees-contact', array('sectionTitleTag' => 'h4', 'sectionsSeparator' => '<br/>', 'insertItemProps' => true)) ?>
		</div>
    </div>
</li>
<?php endif; ?>

<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_coordonnees', $ficheData) ; ?>
