<?php
/**
 * Template d'affichage de block dans une page fiche détaillée - lien de réservation en ligne
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks-fiche3
 *
 * @version 3.3
 *
 */

$result = '';
if(BridgeBlockService::textBlockIsNotEmpty($fiche, $fiche->ficheBlocks, "lien-de-reservation-en-ligne"))
    $result = BridgeBlockService::extractNamedBlockFirstTextValue($blockTemp);

BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_lien_reservation', $ficheData);

if($result != ''): ?>
<li>
	<div class="uk-grid uk-flex-middle">
	   <div class="uk-width-1-6 uk-text-center"><i class="fa fa-booking fa-3x"></i></div>
        <div class="uk-width-5-6">
            <a target="_blank" href="<?= $result; ?>" data-dnc-tresa="<?= $fiche->productCode ?>" data-product-code="<?= $fiche->productCode ?>" data-text-key="<?= (string) $fiche->productTextKey ?>" class="uk-width-1-1 reservation <?= (string) $fiche->ficheBlocks->{'lien-de-reservation-en-ligne'}->cssClass ?>"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_RESERVATION', 'Réservation','plugin-sit'); ?></a>
        </div>
	</div>
</li>
<?php endif; ?>

<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_lien_reservation', $ficheData); ?>
