<?php
/**
 * Template d'affichage de block dans une page fiche détaillée - bloc téléphone de contact - modèle fiche 3
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks-fiche3
 *
 * @version 3.3
 *
 */

$tel = '';
if(BridgeBlockService::textBlockIsNotEmpty($fiche, $fiche->ficheBlocks, "telephone-s-de-contact"))
    $tel = BridgeBlockService::extractNamedBlockFirstTextValue ( $fiche->ficheBlocks, "telephone-s-de-contact");

BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_telephone', $ficheData);
if($tel != ''): ?>
<li>
	<div class="uk-grid uk-flex-middle">
	   <div class="uk-width-1-6 uk-text-center"><i class="fa fa-phone fa-3x"></i></div>
	   		<div class="uk-width-5-6">
                <?php if ($ficheParameters->hidePhoneWithXX == true): ?>
                    <a class="uk-width-1-1 phone <?= (string) $fiche->ficheBlocks->{'telephone-s-de-contact'}->cssClass ?>" data-dnc-ttel="<?= $fiche->productCode ?>" data-product-code="<?= $fiche->productCode ?>" data-text-key="<?= (string) $fiche->productTextKey ?>" uk-toggle="target: .phone"><?= substr($tel,0,12).'XX'; ?></a>
                    <a href="tel:<?= str_replace(' ','',$tel); ?>" class="uk-width-1-1 phone <?= (string) $fiche->ficheBlocks->{'telephone-s-de-contact'}->cssClass ?>" hidden ><?= $tel; ?></a>
                <?php else: ?>
                    <a href="tel:<?= str_replace(' ','',$tel); ?>" class="uk-width-1-1 phone <?= (string) $fiche->ficheBlocks->{'telephone-s-de-contact'}->cssClass ?>" ><?= $tel; ?></a>
                <?php endif; ?>
		</div>
	</div>
</li>
<?php endif; ?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_telephone', $ficheData);  ?>

