<?php
/**
 * Template d'affichage de block dans une page fiche détaillée - scripts pour la carte de localisation
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3
 *
 */

if(!empty($fiche->latitude) && !empty($fiche->longitude)): ?>
	<script type="text/javascript">
        // <!--
    	// Gère le javascript de la carto
    	bridgeDocumentReady(function($j)
		{
			window.markercmpt = 0;
			window.mapService = new dncLeafletServices('maps-loc');
			window.mapService.mapoptions = {
				zoom: '14', // Niveau de Zoom de départ
				centerlat: <?= $fiche->latitude; ?>, // Latitude du centre au départ
				centerlon: <?= $fiche->longitude; ?>, // Longitude du centre au départ
				maptype: 'MAPTYPE_OPENSTREETMAPS', // Type de vue : ROAD, SATTELITE, HYBRID, 3D
				gridSize: 0,
				maxZoom: 5,
                scrollWheelZoom: false
			};
			var mapdiv = document.getElementById("maps-loc");
			//abso();

			window.mapService.defaultIconOptions =  {
                iconSize:     [<?= $bridgeParameters->marker_map_width ?>, <?= $bridgeParameters->marker_map_height ?>],
                iconAnchor:   [<?= round($bridgeParameters->marker_map_width/2) ?>, <?= round($bridgeParameters->marker_map_height/2) ?>],
                popupAnchor:  [0, -3]
    		};
    		window.mapService.init();

    		window.mapService.switchToWordpress();
    		window.mapService.disabledMouseWheel();
			// On ajoute le point
			window.mapService.addmarker ("1", <?= $fiche->latitude ?>, <?= $fiche->longitude ?>,'<?= BridgeCmsAbstractLayer::esc_js($fiche->name) ?>','<?= $bridgeParameters->marker_map ?>') ;


			<?php if($fiche->kml != ''): ?>
				window.mapService.addkml('<?= $fiche->kml; ?>','1');
			<?php endif; ?>

            window.mapService.centeronmarker("1","14");
            window.mapService.fitboundstomarkers();

            UIkit.util.on('#tabs-sit > .localisation','beforeshow', function(){
                window.mapService.centeronmarker("1","14");
                window.mapService.reDraw();
                window.mapService.fitboundstomarkers();
                //abso();
            });
		});

        jQuery(window).resize(function() {
            //abso();
        });

        function abso() {
            var sizeneg = (jQuery(window).width()-jQuery('#maps-loc').parents('.elementor-container').width()+100)/2;
               jQuery('#maps-loc').css({
                position: 'relative',
                width: jQuery(window).width(),
                //left: '50%',
                marginLeft: '-'+sizeneg+'px'
            });
        }
        // -->
	</script>
<?php endif; ?>
