<?php
/**
 * Template d'affichage des blocks personnalisés dans une page fiche détaillée
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3
 *
 */

$blocks = $fiche->ficheBlocks->custom;

$hierarchicalCustomBlocks = array();
if (isset($fiche) && is_object($fiche) && !empty($fiche->ficheBlocks) && isset($blocks) && count($blocks) > 0) {
    $hierarchicalCustomBlocks = BridgeBlockService::prepareCustomBlocksDisplay($fiche, $blocks, $ficheParameters);
}

if(isset($_REQUEST['toto'])) {
    echo '------ HIERACHICAL BLOCK DEBUT ';
    print_r($hierarchicalCustomBlocks);
    echo '------ HIERACHICAL BLOCK FIN ';
}

// Signets pour savoir quand insérer des séparateurs
$previousGroupId = -1;
$previousBlockId = -1;

$groupTitleTag = (isset($bridgeParameters->tag_fiche_titre_groupe_blocperso) && !empty($bridgeParameters->tag_fiche_titre_groupe_blocperso)) ? $bridgeParameters->tag_fiche_titre_groupe_blocperso : 'h2' ;
$blockTitleTag = (isset($bridgeParameters->tag_fiche_titre_blocperso) && !empty($bridgeParameters->tag_fiche_titre_blocperso)) ? $bridgeParameters->tag_fiche_titre_blocperso : 'h3' ;


BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_custom_blocks', $ficheData);
//$nbOnglets = 0;
if (count($hierarchicalCustomBlocks) > 0) : ?>
    <section class="onglet">
        <div uk-grid>
            <div class="uk-width-1-4@m">
                <ul class="uk-tab-left" uk-tab="connect: #onglets; animation: uk-animation-fade">
                    <?php $cpt = 1; foreach ($hierarchicalCustomBlocks as $onglet) : ?>
                        <?php if (isset($onglet->group) && !empty($onglet->group) && $onglet->group == 1): ?>
                            <?php if(!empty($onglet->title)): ?>
                                    <li><a href=""><?= $onglet->title; ?></a></li>
                                <?php else :?>
                                    <li><a href="">Onglet groupe <?= $cpt; ?></a></li>
                                <?php endif; ?>
                        <?php else : ?>
                            <?php  foreach ($onglet->items as $item): ?>
                                <?php if(!empty($item->title)): ?>
                                    <li><a href=""><?= $item->title; ?></a></li>
                                <?php else :?>
                                    <li><a href="">Onglet <?= $cpt; ?></a></li>
                                <?php endif; ?>
                            <?php $cpt++; endforeach; ?>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </ul>
            </div>
            <div class="uk-width-3-4@m">
                   <?php if (isset($_REQUEST['dncdebug']) && $_REQUEST['dncdebug'] == "X") : ?>
                    <code>
                        <pre><?php print_r($hierarchicalCustomBlocks); ?></pre>
                    </code>
                <?php endif; ?>
                <ul id="onglets" class="uk-switcher">
            <?php foreach ($hierarchicalCustomBlocks as $onglet) : ?>
            <?php $groupeactif = false; ?>
            <?php if (true): ?>

                <?php /* if ($nbOnglets > 0): ?>
                    <?php if((!empty($onglet->group) && $onglet->group == 1)): ?>
                        <hr class="block-separator group-separator uk-width-1-1 uk-divider-icon <?= $onglet->separatorClass ?>"/>
                    <?php else: ?>
                        <hr class="block-separator uk-width-1-1 uk-divider-icon <?= $onglet->items[0]->separatorClass ?>"/>
                    <?php endif; ?>
                <?php endif; ?>
                <?php $nbOnglets++;*/ ?>
                <?php $nbItems = 0; ?>

                <?php if (!empty($onglet->group) && $onglet->group == 1): ?>
                        <li>
                        <div id="custom-block-<?= $onglet->blockId ?>" class="custom-block <?= $onglet->class ?>">
                        <<?= $groupTitleTag ?> class="block-group-label "><?= $onglet->title; ?></<?= $groupTitleTag ?>>
                        <div uk-grid>
                        <?php $groupeactif = true; ?>
                <?php endif; ?>

                <?php foreach ($onglet->items as $item): ?>
                    <?php if(isset($onglet->group) && $onglet->group == 1) : ?>
                        <div <?= (!isset($onglet->group) || empty($onglet->group) || $onglet->group != 1) ? 'id="custom-block-' . $item->blockId.'"' : ''; ?> class="custom-block <?= $item->class ?>">
                    <?php else : ?>
                        <li>
                    <?php endif; ?>
                        <?php if ($nbItems > 0): ?>
                            <hr class="block-separator uk-width-1-1 uk-margin-remove-left uk-divider-icon <?= $item->separatorClass ?>"/>
                        <?php endif; ?>
                        <?php if (!empty($item->title)): ?>
                            <<?= $blockTitleTag ?> class="block-label uk-h2"><span><?= $item->title ?></span></<?= $blockTitleTag ?>>
                        <?php endif; ?>

                        <?php if (!empty($item->component)): ?>
                            <?php $blockData = $item->blockData; ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/gabarits/' . $item->component . '.php'); ?>
                        <?php else: ?>
                            <?= $item->html; ?>
                        <?php endif; ?>
                    <?php $nbItems++; ?>
                 <?php if(isset($onglet->group) && $onglet->group == 1) : ?>
                    </div>
                 <?php else : ?>
                        </li>
                    <?php endif; ?>
            <?php endforeach; ?>
            <?php if (!empty($onglet->group) && $onglet->group == 1): ?>
                    </div>
                </div></li>
            <?php endif; ?>
        <?php endif; ?>

        <?php endforeach; ?>
              </ul></div>
        </div>
    </section>
<?php endif; ?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_custom_blocks', $ficheData); ?>
