<?php
/**
 * Template d'affichage de block dans une page fiche détaillée - bloc pictogrammes
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3
 *
 */

BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_pictogrammes', $ficheData);

if(BridgeBlockService::itemsBlockIsNotEmpty($fiche, $fiche->ficheBlocks, 'pictogrammes')):?>
<div class="uk-card uk-card-default uk-card-small uk-margin">
    <div class="uk-card-body uk-text-center uk-position-relative">
    	<span class="pictogrammes  <?= (string) $fiche->ficheBlocks->{'pictogrammes'}->cssClass ?>">
        	<?= BridgeBlockService::renderNamedBlockHtml($fiche->ficheBlocks, 'pictogrammes') ?>
    	</span>
     </div>
</div>
<?php endif; ?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_pictogrammes', $ficheData); ?>
