<?php
/**
 * Template d'affichage du block photos dans une page fiche détaillée
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3
 *
 */

BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_photos', $ficheData);

$images = BridgeBlockService::extractPhotos($fiche->ficheBlocks, 'photos-medias'); ?>

<?php if(count($images) > 0): ?>
<div id="galerie" class="uk-position-relative uk-visible-toggle" tabindex="-1" uk-lightbox="animation: scale">
	<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_galerie', $ficheData); ?>

    <?php if(count($images) > 1): ?>
	<div uk-grid class="uk-grid-medium">
		<div class="uk-width-2-3">
			<a href="<?= $images[0]->url ;?>" data-caption="<?= $images[0]->caption; ?>">
				<img data-src="<?= BridgeUtils::getResizeImageLink($images[0]->url, "tronq", "800", "500", "60") ?>" alt="<?= $images[0]->caption; ?>" uk-img>
            </a>
		</div>
		<div class="uk-width-1-3 uk-flex uk-flex-column uk-flex-between">
			<a href="<?= $images[1]->url ;?>" data-caption="<?= $images[1]->caption; ?>">
				<img data-src="<?= BridgeUtils::getResizeImageLink($images[1]->url, "tronq", "800", "500", "60") ?>" alt="<?= $images[1]->caption; ?>"  uk-img>
            </a>
            <?php if(count($images) > 2): ?>
                <a href="<?= $images[2]->url ;?>" data-caption="<?= $images[2]->caption; ?>">
                    <img data-src="<?= BridgeUtils::getResizeImageLink($images[2]->url, "tronq", "800", "500", "60") ?>" alt="<?= $images[2]->caption; ?>" uk-img>
                </a>
            <?php endif; ?>
            <?php foreach($images as $key=>$image): ?>
            <?php if($key<=2) continue; ?>
            <a href="<?= $images[$key]->url ;?>" data-caption="<?= $images[$key]->caption; ?>" hidden>
				<img data-src="<?= BridgeUtils::getResizeImageLink($images[$key]->url, "tronq", "800", "500", "60") ?>" alt="<?= $images[$key]->caption; ?>" uk-img>
            </a>
            <?php endforeach; ?>
		</div>
	</div>
    <?php else : ?>
        <a href="<?= $images[0]->url ;?>" data-caption="<?= $images[0]->caption; ?>">
				<img data-src="<?= BridgeUtils::getResizeImageLink($images[0]->url, "tronq", "800", "400", "60") ?>" alt="<?= $images[0]->caption; ?>" uk-img>
            </a>
    <?php endif; ?>

    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_galerie', $ficheData); ?>
</div>

<?php endif; ?>

<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_photos', $ficheData); ?>
