<?php
/**
 * Template d'affichage de sommaire des blocs personnalisés  dans une page fiche détaillée
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche
 *
 * @version 3.3
 *
 */

$blocks = $fiche->ficheBlocks->custom;
$descriptifFilled = false;
if(BridgeBlockService::textBlockIsNotEmpty($fiche, $fiche->ficheBlocks, "descriptif"))
    $descriptifFilled = true;

$hierarchicalCustomBlocks = array();
if(isset($fiche) && is_object($fiche) && !empty($fiche->ficheBlocks) && isset($blocks) && count($blocks) > 0) {
    $hierarchicalCustomBlocks = BridgeBlockService::prepareCustomBlocksDisplay($fiche, $blocks, $ficheParameters);
}

// Signets pour savoir quand insérer des séparateurs
$previousGroupId = -1;
$previousBlockId = -1;

?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_sommaire', $ficheData) ; ?>
    <nav class="sommaire uk-navbar-container" uk-sticky="offset:20; end:#bridge-fiche-stop-sticky;  media: 960;" uk-navbar>
        <ul class="uk-navbar-nav " uk-scrollspy-nav="closest: li; scroll: true;cls:uk-text-bold">
    <!--<li><a href="#galerie" uk-scroll><?= BridgeCmsAbstractLayer::__('Galerie','plugin-sit'); ?></a></li>
    <?php if($descriptifFilled): ?>
    <li><a href="#descriptif" uk-scroll><?= BridgeCmsAbstractLayer::__('Descriptif','plugin-sit'); ?></a></li>
    <?php endif; ?>-->

    <?php if (count($hierarchicalCustomBlocks) > 0) : ?>
        <?php foreach ($hierarchicalCustomBlocks as $onglet) : ?>
            <?php if(empty($onglet->title)) continue; ?>
            <li><a href="#custom-block-<?= $onglet->blockId; ?>"><?= $onglet->title; ?></a></li>
        <?php endforeach; ?>
    <?php endif; ?>

   <!-- <?php
    // Si il y a des fiches associées   : FINI => infos supp 3 et 4 pour le moment on ne gère pas le lien dans le sommaire
    if(false && isset($coupledProducts) && is_array($coupledProducts) && count($coupledProducts) > 0) :?>
        <li><a href="#coupled" uk-scroll><?= BridgeCmsAbstractLayer::__('A voir aussi', 'plugin-sit') ?></a></li>
    <?php endif; ?>-->

</ul>
</nav>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_sommaire', $ficheData) ; ?>
