<?php
/**
 * Template d'affichage de formulaire email de contact
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3
 *
 */

?>
<script type="text/javascript">
    // <!--
    function isEmail(email) {
        var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
        return regex.test(email);
    }
    
    function isPhone(phone){
        var regex = /^(?:(?:\+|00)33|0)\s*[1-9](?:[\s.-]*\d{2}){4}$/;
        return regex.test(phone);
    }
    
    function bridgeVerifyForm() {
        let res = { success: false };
        let nbfieldsOk = 0;
        if(jQuery("#bridge-nom").val() === '') {
            jQuery("#bridge-nom").removeClass('uk-form-success').addClass('uk-form-danger');
        } else {
            jQuery("#bridge-nom").removeClass('uk-form-danger').addClass('uk-form-success');
            res.name = jQuery("#bridge-nom").val();
            nbfieldsOk++;
        }
        if(jQuery("#bridge-email").val() === '') {
            jQuery("#bridge-email").removeClass('uk-form-success').addClass('uk-form-danger');
        } else {
            jQuery("#bridge-email").removeClass('uk-form-danger').addClass('uk-form-success');
            res.email = jQuery("#bridge-email").val();
            if(isEmail(res.email)){
                nbfieldsOk++;
            } else {
                jQuery("#bridge-email").removeClass('uk-form-success').addClass('uk-form-danger');
                alert('<?= BridgeCmsAbstractLayer::__('Error Email Format, ex : john.doe@gmail.com'); ?>');

            }
        }
        
        /* if(jQuery("#bridge-phone").val() === '') {
            jQuery("#bridge-phone").removeClass('uk-form-success').addClass('uk-form-danger');
        } else {
            jQuery("#bridge-phone").removeClass('uk-form-danger').addClass('uk-form-success');
            res.phone = jQuery("#bridge-phone").val();
            if(isPhone(res.phone)){
                nbfieldsOk++;
            } else {
                jQuery("#bridge-phone").removeClass('uk-form-success').addClass('uk-form-danger');
                alert('<?= BridgeCmsAbstractLayer::__('Error Phone Format, ex : +33123456789'); ?>');

            }

        }*/
        
        if(jQuery("#bridge-message").val() === '') {
            jQuery("#bridge-message").removeClass('uk-form-success').addClass('uk-form-danger');
        } else {
            jQuery("#bridge-message").removeClass('uk-form-danger').addClass('uk-form-success');
            res.message = jQuery("#bridge-message").val();
            nbfieldsOk++;
        }
        if(nbfieldsOk === 3) { // 4 si on met le téléphone
            res.success = true;
        }
        return res;
    }
    // -->
</script>
<?php if ($ficheParameters->emailFormAntispam == 'RECAPTCHAV3' || $ficheParameters->emailFormAntispam == 'RECAPTCHAV2'): ?>
        <?php if ($ficheParameters->emailFormAntispam == 'RECAPTCHAV2'): ?>
            <script type="text/javascript">
                var bridgeRecaptchav2Ready = function() {
                    grecaptcha.render(
                        'bridge-recaptchav2-container', {
                            'sitekey' : '<?= $ficheParameters->recaptchav2_site_key ?>',
                            'theme' : 'light'
                        });
                };
            </script>
            <script src="https://www.google.com/recaptcha/api.js?onload=bridgeRecaptchav2Ready&render=explicit"
                    async defer></script>
        <?php endif; ?>

    <?php if ($ficheParameters->emailFormAntispam == 'RECAPTCHAV3'): ?>
        <script src="https://www.google.com/recaptcha/api.js?render=<?= $ficheParameters->recaptchav3_site_key ?>"></script>
    <?php endif; ?>
    <script type="text/javascript">
        // <!--
        jQuery(document).ready(function() {
            jQuery('#bridge-btn-envoyer-email').click(function(e) {
                e.preventDefault();
                jQuery('#bridge-btn-envoyer-email').attr('disabled', 'true');
                // Vérification du formulaire
                let postParams = bridgeVerifyForm();
                if(postParams.success !== true) {
                    jQuery('#bridge-btn-envoyer-email').removeAttr('disabled');
                    return;
                }
                postParams.dest = jQuery('#bridge-email-dest').val();
                postParams.subject = jQuery('#bridge-email-subject').val();
                postParams.productCode = jQuery('#bridge-product-code').val();
                postParams.productName = jQuery('#bridge-product-name').val();
                postParams.webPageId = jQuery('#bridge-id-fiche').val();
                postParams.action = "bridge_send_email_recaptcha";

                <?php if ($ficheParameters->emailFormAntispam == 'RECAPTCHAV2'): ?>
                    postParams.token = grecaptcha.getResponse();
                    jQuery.ajax({
                        type: "POST",
                        url: "<?= BridgeUtils::getAjaxURL(); ?>",
                        data: postParams,
                        dataType: "json",
                        error: function( jqXHR, textStatus, errorThrown ) {
                            jQuery('#bridge-btn-envoyer-email').removeAttr('disabled');
                            jQuery('#bridge-send-log').removeClass('uk-alert-success').addClass('uk-alert-danger').html('Erreur ' + textStatus).show();
                        }
                    }).done(function (data) {
                        jQuery('#bridge-btn-envoyer-email').removeAttr('disabled');
                        if(data.success) {
                            jQuery('#bridge-send-log').removeClass('uk-alert-danger').addClass('uk-alert-success').html(data.data).show();
                        } else {
                            jQuery('#bridge-send-log').removeClass('uk-alert-success').addClass('uk-alert-danger').html(data.data).show();
                        }
                    });
                <?php endif; ?>
                <?php if ($ficheParameters->emailFormAntispam == 'RECAPTCHAV3'): ?>
                    grecaptcha.ready(function() {
                        grecaptcha.execute('<?= $ficheParameters->recaptchav3_site_key ?>', {action: 'submit'}).then(function(token) {
                            postParams.token = token;

                            jQuery.ajax({
                                type: "POST",
                                url: "<?= BridgeUtils::getAjaxURL(); ?>",
                                data: postParams,
                                dataType: "json",
                                error: function( jqXHR, textStatus, errorThrown ) {
                                    jQuery('#bridge-btn-envoyer-email').removeAttr('disabled');
                                    jQuery('#bridge-send-log').removeClass('uk-alert-success').addClass('uk-alert-danger').html('Erreur ' + textStatus).show();
                                }
                            }).done(function (data) {
                                jQuery('#bridge-btn-envoyer-email').removeAttr('disabled');
                                if(data.success) {
                                    jQuery('#bridge-send-log').removeClass('uk-alert-danger').addClass('uk-alert-success').html(data.data).show();
                                } else {
                                    jQuery('#bridge-send-log').removeClass('uk-alert-success').addClass('uk-alert-danger').html(data.data).show();
                                }
                            });
                        });
                    });
                <?php endif; ?>
            });
        });
        // -->
    </script>
<?php endif; ?>
<div id="modal-contact" class="uk-flex-top" uk-modal>
    <div class="uk-modal-dialog uk-modal-body uk-margin-auto-vertical">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <form>
            <fieldset class="uk-fieldset">
                <input type="hidden" id="bridge-product-name" value="<?= $fiche->name ?>"/>
                <input type="hidden" id="bridge-product-code" value="<?= $fiche->productCode ?>"/>
                <input type="hidden" id="bridge-id-fiche" value="<?= $ficheParameters->webPageId ?>"/>

                <?php if ($ficheParameters->emailModeTest): ?>
                    <input type="hidden" id="bridge-email-dest" value="<?= $ficheParameters->emailTestEmailAddress ?>"/>
                <?php else: ?>
                    <input type="hidden" id="bridge-email-dest" value="<?= $email ?>"/>
                <?php endif; ?>


                <input type="hidden" id="bridge-email-subject" value="<?= !empty($ficheParameters->emailPrestSubject )?BridgeCmsAbstractLayer::esc_attr($ficheParameters->emailPrestSubject):'' ?>"/>

                <legend class="uk-legend"><?= BridgeCmsAbstractLayer::__('Contact','plugin-sit'); ?></legend>

                <div class="uk-margin">
                    <?php /* <label><?= BridgeCmsAbstractLayer::__('Votre nom', 'plugin-sit') ?></label> */ ?>
                    <input class="uk-input" type="text" id="bridge-nom" required name="bridge-nom" placeholder="<?= BridgeCmsAbstractLayer::esc_attr(BridgeCmsAbstractLayer::__('Votre nom', 'plugin-sit')) ?> *">
                </div>
                <div class="uk-margin">
                    <?php /*<div uk-grid class="uk-grid-small">
                        <div class="uk-width-1-2">
                             <label><?= BridgeCmsAbstractLayer::__('Votre nom', 'plugin-sit') ?></label> */ ?>
                             <input class="uk-input" type="email" required id="bridge-email" name="bridge-email" placeholder="<?= BridgeCmsAbstractLayer::esc_attr(BridgeCmsAbstractLayer::__('Votre email', 'plugin-sit')) ?> *" pattern="^([a-zA-Z0-9_\-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([a-zA-Z0-9\-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$">
                        <?php /*</div>
                        <div class="uk-width-1-2">
                             <label><?= BridgeCmsAbstractLayer::__('Votre nom', 'plugin-sit') ?></label> 
                             <input class="uk-input" type="tel" id="bridge-phone" name="bridge-phone" placeholder="<?= BridgeCmsAbstractLayer::esc_attr(BridgeCmsAbstractLayer::__('+33 XX XX XX XX', 'plugin-sit')) ?> *" required>
                        </div>
                    </div>*/ ?>
                    
                </div>

                <div class="uk-margin">
                    <?php /* <label><?= BridgeCmsAbstractLayer::__('Votre nom', 'plugin-sit') ?></label> */ ?>
                    <textarea class="uk-textarea" rows="5" id="bridge-message" required name="bridge-message" placeholder="<?= BridgeCmsAbstractLayer::esc_attr(BridgeCmsAbstractLayer::__('Votre message', 'plugin-sit')) ?> *"></textarea>
                </div>

                <?php if ($ficheParameters->emailFormAntispam == 'RECAPTCHAV2'): ?>
                    <div class="uk-margin" id="bridge-recaptchav2-container">

                    </div>
                <?php endif; ?>
                <?php if ($ficheParameters->emailModeTest): ?>
                    <div class="uk-alert uk-alert-warning">
                        Mode TEST : les emails seront envoyés à l'adresse: <?= $ficheParameters->emailTestEmailAddress ?>
                    </div>
                <?php endif; ?>

            </fieldset>
            <p class="uk-text-right">
                <span class="uk-float-left">* Champs obligatoires</span>
                <button class="uk-button uk-button-default uk-modal-close" type="button"><?= BridgeCmsAbstractLayer::__('Annuler', 'plugin-sit') ?></button>
                <button class="uk-button uk-button-primary" id="bridge-btn-envoyer-email" name="bridge-btn-envoyer-email" type="button" data-dnc-temail="<?= $fiche->productCode ?>" data-product-code="<?= $fiche->productCode ?>" data-text-key="<?= (string) $fiche->productTextKey ?>"><?= BridgeCmsAbstractLayer::__('Envoyer', 'plugin-sit') ?></button>
            </p>
            <div class="uk-alert uk-margin-top" id="bridge-send-log" style="display:none">

            </div>
        </form>
    </div>
</div>
