<?php
/**
 * Template d'affichage de la zone email de contact
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3
 *
 */

$bonusMailto = '?subject=';
if(!empty($ficheParameters->emailPrestSubject ))
    $bonusMailto .= rawurlencode($ficheParameters->emailPrestSubject);
$bonusMailto .= '&body=';
if(!empty($ficheParameters->emailPrestBody ))
    $bonusMailto .= rawurlencode($ficheParameters->emailPrestBody);

$email = '';
if(BridgeBlockService::textBlockIsNotEmpty($fiche, $fiche->ficheBlocks, "email-de-contact"))
    $email = BridgeBlockService::extractNamedBlockFirstTextValue ( $fiche->ficheBlocks, "email-de-contact");

$formSettingsAreValid = false;
if($ficheParameters->emailLinkType == 'FORMULAIRE' && $ficheParameters->emailFormAntispam == 'RECAPTCHAV3' && ! empty($ficheParameters->recaptchav3_site_key) && !empty($ficheParameters->recaptchav3_secret_key))
    $formSettingsAreValid = true;
if($ficheParameters->emailLinkType == 'FORMULAIRE' && $ficheParameters->emailFormAntispam == 'RECAPTCHAV2' && ! empty($ficheParameters->recaptchav2_site_key) && !empty($ficheParameters->recaptchav2_secret_key))
    $formSettingsAreValid = true;

BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_email', $ficheData);
?>


<?php if($ficheParameters->emailLinkType == 'LIEN_MAILTO' && !empty($email)): ?>
    <a data-dnc-temail="<?= $fiche->productCode ?>" data-product-code="<?= $fiche->productCode ?>" data-text-key="<?= (string) $fiche->productTextKey ?>" href="mailto:<?= str_replace(' ','',$email) . $bonusMailto; ?>" target="_blank" class="uk-button uk-width-1-1 uk-button-default uk-margin-bottom email-de-contact"><?= BridgeCmsAbstractLayer::__('Contact','plugin-sit'); ?></a>

<?php elseif ($ficheParameters->emailLinkType == 'FORMULAIRE' && !empty($email) && $formSettingsAreValid): ?>
    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/email-de-contact-formulaire.php'); ?>
    <a href="#modal-contact" class="uk-button uk-width-1-1 uk-button-default uk-margin-bottom email-de-contact <?= (string) $fiche->ficheBlocks->{'email-de-contact'}->cssClass ?>" uk-toggle><?= BridgeCmsAbstractLayer::__('Contact','plugin-sit'); ?></a>
<?php elseif ($ficheParameters->emailLinkType == 'FORMULAIRE' && !empty($email) && !$formSettingsAreValid): ?>
    <div class="uk-alert-danger">
        <h3>Erreur : La sécurité antispam du formulaire de contact n'est pas paramétrée dans Bridge</h3>
    </div>
<?php endif; ?>


<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_email', $ficheData); ?>
