<?php
/**
 * Template d'affichage de la zone email de contact
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3
 *
 */

$bonusMailto = '?subject=';
if(!empty($ficheParameters->emailPrestSubject ))
    $bonusMailto .= rawurlencode($ficheParameters->emailPrestSubject);
$bonusMailto .= '&body=';
if(!empty($ficheParameters->emailPrestBody ))
    $bonusMailto .= rawurlencode($ficheParameters->emailPrestBody);

$email = '';
if(BridgeBlockService::textBlockIsNotEmpty($fiche, $fiche->ficheBlocks, "email-de-contact"))
    $email = BridgeBlockService::extractNamedBlockFirstTextValue ( $fiche->ficheBlocks, "email-de-contact");

BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_email');
?>

<div class="contact-email">
    <a data-dnc-temail="<?= $fiche->productCode ?>" data-product-code="<?= $fiche->productCode ?>" data-text-key="<?= (string) $fiche->productTextKey ?>" href="mailto:<?= str_replace(' ','',$email) . $bonusMailto; ?>" target="_blank" class="uk-link email-de-contact"><?= $email; ?></a>
</div>

<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_email'); ?>
