<?php
/**
 * Template d'affichage de block dans une page fiche détaillée - bloc téléphone de contact
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3.21
 *
 */


BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_telephone');
if(BridgeBlockService::textBlockIsNotEmpty($fiche, $fiche->ficheBlocks, "telephone-s-de-contact")) : ?>

    <div class="phones">
        
   <?php 
    $itemIcon = '';
    $rendericon = '';
    $blocks_object = $fiche->ficheBlocks;
    $block_name = "telephone-s-de-contact";
    if(is_object($blocks_object) && property_exists($blocks_object, $block_name)) {
        $renderBlockData = $blocks_object->$block_name;
        if ( isset( $renderBlockData ) && is_object($renderBlockData->content) && !empty($renderBlockData->content->fields)) {
            foreach($renderBlockData->content->fields as $index=>$section) {
                $countitems = count($section->items);
                if($countitems > 2) $countitems = 2;
                
                foreach($section->items as $indexItem=>$item) { ?>
                    <?php if(isset($item->textValue)): ?>
                        <?php $tel= $item->textValue; ?>
                        <div class="phone<?= $index+1; ?> notranslate">
                             <a href="tel:<?= str_replace(' ','',$tel); ?>" class="uk-link phone phone<?= $indexItem; ?>  <?= (string) $fiche->ficheBlocks->{'telephone-s-de-contact'}->cssClass ?>"><?= str_replace(', ',' - ',$tel); ?></a>
                        </div>
                    <?php endif; ?>
                    <?php

                }
          
            }
            
        }
       
    }

    ?>

</div>
<?php endif; ?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_telephone');  ?>

        
