<?php
/**
 * Template d'affichage du block photos dans une page fiche détaillée
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.2
 *
 */

BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_photos');

$images = BridgeBlockService::extractPhotos($fiche->ficheBlocks, 'photos-medias'); ?>

<?php if(count($images) > 0): ?>
<div id="galerie" class="uk-position-relative uk-visible-toggle" tabindex="-1" uk-lightbox="animation: scale">
    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_galerie'); ?>

    <?php if(count($images) > 1): ?>
    <div uk-grid class="uk-grid-small">
        <div class="uk-width-expand">
            <?php //print_r($images[0]); ?>
            <a href="<?= $images[0]->url ;?>" data-caption="<?= (isset($images[0]->title) && !empty($images[0]->title)) ? $images[0]->title : ''; ?>">
                <figure>
                    <img data-src="<?= BridgeUtils::getResizeImageLink($images[0]->url, "tronq", "800", "800", "80") ?>" alt="" uk-img>
                    <figcaption uk-tooltip title="<?= $images[0]->credit; ?>"><?= (isset($images[0]->title) && !empty($images[0]->title)) ? $images[0]->title : ''; ?><span class="copyright"></span></figcaption>
                </figure>
            </a>
        </div>
        <div class="uk-width-1-3@l uk-flex uk-flex-column uk-flex-between uk-visible@l">
            <a href="<?= $images[1]->url ;?>" data-caption="<?= (isset($images[1]->title) && !empty($images[1]->title)) ? $images[1]->title : ''; ?>">
                <figure>

                    <img data-src="<?= BridgeUtils::getResizeImageLink($images[1]->url, "tronq", "500", "500", "80") ?>" alt=""  uk-img>
                    <figcaption uk-tooltip title="<?= $images[1]->credit; ?>"><?= (isset($images[1]->title) && !empty($images[1]->title)) ? $images[1]->title : ''; ?><span class="copyright"></span></figcaption>
                </figure>
            </a>
            <?php if(isset($images[2]) && !empty($images[2]->url)) : ?>
            <a href="<?= $images[2]->url ;?>" data-caption="<?= (isset($images[2]->title) && !empty($images[2]->title)) ? $images[2]->title : ''; ?>" class="uk-position-relative">
                <figure>
                    <img data-src="<?= BridgeUtils::getResizeImageLink($images[2]->url, "tronq", "500", "500", "80") ?>" alt="" uk-img>
                    <figcaption uk-tooltip title="<?= $images[2]->credit; ?>"><?= (isset($images[2]->title) && !empty($images[2]->title)) ? $images[2]->title : ''; ?><span class="copyright"></span></figcaption>
                    <div class="bulle-galerie">
                        <i class="fa fa-image"></i>
                        <span>Voir les photos</span>
                    </div>
                </figure>
            </a>
            <?php else : ?>
            <div class="uk-position-relative bridge-no-media-third">
                <canvas height="500" width="500"></canvas>
                <div class="bulle-galerie">
                    <i class="fa fa-image"></i>
                    <span>Voir les photos</span>
                </div>
            </div>
            <?php endif; ?>
            <?php foreach($images as $key=>$image): ?>
            <?php if($key<=2) continue; ?>
            <a href="<?= $images[$key]->url ;?>" data-caption="<?= (isset($images[$key]->title) && !empty($images[$key]->title)) ? $images[$key]->title : ''; ?>" hidden>
                <img data-src="<?= BridgeUtils::getResizeImageLink($images[$key]->url, "tronq", "800", "800", "80") ?>" alt="" uk-img>
            </a>
            <?php endforeach; ?>
        </div>
    </div>
    <?php else : ?>
        <a href="<?= $images[0]->url ;?>" data-caption="<?= (isset($images[0]->title) && !empty($images[0]->title)) ? $images[0]->title : ''; ?>">
                <img data-src="<?= BridgeUtils::getResizeImageLink($images[0]->url, "tronq", "1200", "650", "60") ?>" alt="<?= (!empty($images[0]->title)) ? $images[0]->title : ''; ?>" uk-img>
            </a>
    <?php endif; ?>

    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_galerie'); ?>
</div>

<?php endif; ?>

<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_photos'); ?>
