<?php
/**
 * Template d'affichage de sommaire des blocs personnalisés  dans une page fiche détaillée
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche
 *
 * @version 3.3
 *
 */

$blocks = $fiche->ficheBlocks->custom;
$descriptifFilled = false;
if(BridgeBlockService::textBlockIsNotEmpty($fiche, $fiche->ficheBlocks, "descriptif"))
    $descriptifFilled = true;

$hierarchicalCustomBlocks = array();
if(isset($fiche) && is_object($fiche) && !empty($fiche->ficheBlocks) && isset($blocks) && count($blocks) > 0) {
    $hierarchicalCustomBlocks = BridgeBlockService::prepareCustomBlocksDisplay($fiche, $blocks, $ficheParameters);
}

// Signets pour savoir quand insérer des séparateurs
$previousGroupId = -1;
$previousBlockId = -1;

?>
<div class="uk-grid uk-flex uk-flex-middle uk-flex-center uk-width-1-1 uk-grid-collapse">
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_sommaire',$ficheData) ; ?>
    <div class="uk-width-expand">
    <nav class="bridge-sommaire uk-width-1-1" uk-navbar>
        <ul class="uk-navbar-nav uk-navbar-center" uk-scrollspy-nav="closest: li; scroll: true;offset: 150">
            <li><a href="#galerie" title="<?= BridgeCmsAbstractLayer::__('Galerie','plugin-sit'); ?>"><?=  BridgeCmsAbstractLayer::__('Galerie','plugin-sit'); ?></a></li>
             <?php if (count($hierarchicalCustomBlocks) > 0) : ?>
                <?php foreach ($hierarchicalCustomBlocks as $onglet) : ?>
                    <?php if(empty($onglet->title)) continue; ?>
                    <li><a href="#<?= BridgeUtils::slugify($onglet->title); ?>" title="<?= htmlspecialchars($onglet->title, ENT_QUOTES); ?>"><?= $onglet->title; ?></a></li>
                <?php endforeach; ?>
            <?php endif; ?>
        </ul>
    </nav>
</div>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_sommaire',$ficheData) ; ?>
</div>


<script type="text/javascript">
const container = document.querySelector('#detailfiche');
const links = Array.from(document.querySelectorAll('ul[uk-scrollspy-nav] a'));

const targets = links
  .map(a => document.querySelector(a.hash))
  .filter(Boolean);

console.log(targets);

const observer = new IntersectionObserver((entries) => {
  // entrée la plus visible
  const visible = entries
    .filter(e => e.isIntersecting)
    .sort((a,b) => b.intersectionRatio - a.intersectionRatio)[0];
  if (!visible) return;
  const id = '#' + visible.target.id;
  links.forEach(li => li.parentElement.classList.toggle('uk-active', li.hash === id));
}, { root: container, threshold: [0.25, 0.5, 0.75] });

targets.forEach(t => observer.observe(t));
</script>
