<?php
/**
 * Template d'affichage du block photos dans une page fiche détaillée itineraire
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks-ficheitineraire
 *
 * @version 3.3
 *
 */

$images = BridgeBlockService::extractPhotos($fiche->ficheBlocks, 'photos-medias');
BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_photos', $ficheData);
if(count($images) > 0): ?>
		<div class="uk-position-relative uk-visible-toggle" tabindex="-1" uk-slideshow="animation: slide;max-height: 450">

	    <ul class="uk-slideshow-items" uk-lightbox>
	    	<?php $i=0; foreach($images as $image) : $i++; ?>
	        <li>
	            <a href="<?= $image->url; ?>"><img src="<?= BridgeUtils::getResizeImageLink($image->url, "tronq", "1200", "450", "60") ?>" alt="" uk-cover /></a>
	        </li>
	      	<?php endforeach; ?>
	    </ul>

	    <div class="uk-light">
	        <a class="uk-position-center-left uk-position-small uk-hidden-hover" href="#" uk-slidenav-previous uk-slideshow-item="previous"></a>
	        <a class="uk-position-center-right uk-position-small uk-hidden-hover" href="#" uk-slidenav-next uk-slideshow-item="next"></a>
	    </div>
		</div>
<?php endif; ?>

<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_photos', $ficheData); ?>
