<?php
/**
 * Template d'affichage des blocks personnalisés dans une page fiche détaillée
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3
 *
 */

$blocks = $fiche->ficheBlocks->custom;

$hierarchicalCustomBlocks = array();
if (isset($fiche) && is_object($fiche) && !empty($fiche->ficheBlocks) && isset($blocks) && count($blocks) > 0) {
    $hierarchicalCustomBlocks = BridgeBlockService::prepareCustomBlocksDisplay($fiche, $blocks, $ficheParameters);
}

if(isset($_REQUEST['toto'])) {
    echo '------ HIERACHICAL BLOCK DEBUT ';
    print_r($hierarchicalCustomBlocks);
    echo '------ HIERACHICAL BLOCK FIN ';
}

// Signets pour savoir quand insérer des séparateurs
$previousGroupId = -1;
$previousBlockId = -1;

$groupTitleTag = (isset($bridgeParameters->tag_fiche_titre_groupe_blocperso) && !empty($bridgeParameters->tag_fiche_titre_groupe_blocperso)) ? $bridgeParameters->tag_fiche_titre_groupe_blocperso : 'h2' ;
$blockTitleTag = (isset($bridgeParameters->tag_fiche_titre_blocperso) && !empty($bridgeParameters->tag_fiche_titre_blocperso)) ? $bridgeParameters->tag_fiche_titre_blocperso : 'h3' ;


BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_custom_blocks');
$nbOnglets = 0;
if (count($hierarchicalCustomBlocks) > 0) : ?>
    <section class="onglet">
        <div uk-grid>
            <?php foreach ($hierarchicalCustomBlocks as $onglet) : ?>
            <?php $groupeactif = false; ?>
            <?php if (true): ?>
                <?php if (isset($_REQUEST['dncdebug']) && $_REQUEST['dncdebug'] == "X") : ?>
                    <code>
                        <pre><?php print_r($blockData); ?></pre>
                    </code>
                <?php endif; ?>

                <?php $nbItems = 0; ?>

                <?php if (!empty($onglet->group) && $onglet->group == 1): ?>
                    <div id="custom-block-<?= $onglet->blockId ?>" class="custom-block <?= $onglet->class ?>">
                        <<?= $groupTitleTag ?> class="block-group-label"><?= $onglet->title; ?></<?= $groupTitleTag ?>>
                        <div uk-grid>
                        <?php $groupeactif = true; ?>
                <?php endif; ?>

                <?php foreach ($onglet->items as $item): ?>
                    <?php if (!empty($item->html) || !empty($item->component)): ?>
                    <div <?= (!isset($onglet->group) || empty($onglet->group) || $onglet->group != 1) ? 'id="custom-block-' . $item->blockId. '"': ''; ?> class="custom-block <?= $item->class ?>">

                         <?php if (!empty($item->title) && (!empty($item->html) || !empty($item->component))): ?>
                            <<?= $blockTitleTag ?> class="block-label uk-h2"><span><?= $item->title ?></span></<?= $blockTitleTag ?>>
                        <?php endif; ?>

                        <?php if (!empty($item->component)): ?>
                            <?php $blockData = $item->blockData; ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/gabarits/' . str_replace('.php','',$item->component) . '.php'); ?>
                        <?php else: ?>
                            <?= $item->html; ?>
                        <?php endif; ?>
                    <?php $nbItems++; ?>
                    <?php if ($nbOnglets > 0): ?>
                        <?php if((!empty($onglet->group) && $onglet->group == 1)): ?>
                            <hr class="block-separator group-separator uk-width-1-1 uk-divider-icon <?= $onglet->separatorClass ?>"/>
                        <?php else: ?>
                            <hr class="block-separator uk-width-1-1 uk-divider-icon <?= $onglet->items[0]->separatorClass ?>"/>
                        <?php endif; ?>
                    <?php endif; ?>

                </div>
                <?php $nbOnglets++; ?>
                <?php endif; ?>
            <?php endforeach; ?>
            <?php if (!empty($onglet->group) && $onglet->group == 1): ?>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>

        <?php endforeach; ?>
        </div>
    </section>
<?php endif; ?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_custom_blocks'); ?>
