<?php
/**
 * Template d'affichage de block dans une page fiche détaillée - bloc téléphone de contact
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3
 *
 */

$tel = '';
if(BridgeBlockService::textBlockIsNotEmpty($fiche, $fiche->ficheBlocks, "telephone-s-de-contact"))
    $tel = BridgeBlockService::extractNamedBlockFirstTextValue ( $fiche->ficheBlocks, "telephone-s-de-contact");

BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_telephone');
if($tel != ''): ?>
    <?php if ($ficheParameters->hidePhoneWithXX == true): ?>
        <a class="uk-button uk-width-1-1 uk-button-default uk-margin-bottom phone  <?= (string) $fiche->ficheBlocks->{'telephone-s-de-contact'}->cssClass ?>" data-dnc-ttel="<?= $fiche->productCode ?>" data-product-code="<?= $fiche->productCode ?>" data-text-key="<?= (string) $fiche->productTextKey ?>" uk-toggle="target: .phone"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_APPELER', 'APPELER', 'plugin-sit') ?></a>
        <a href="tel:<?= str_replace(' ','',$tel); ?>" class="uk-button uk-width-1-1 uk-button-default uk-margin-bottom phone <?= (string) $fiche->ficheBlocks->{'telephone-s-de-contact'}->cssClass ?>" hidden ><?= $tel; ?></a>
    <?php else: ?>
        <a href="tel:<?= str_replace(' ','',$tel); ?>" class="uk-button uk-width-1-1 uk-button-default uk-margin-bottom phone  <?= (string) $fiche->ficheBlocks->{'telephone-s-de-contact'}->cssClass ?>"><?= $tel; ?></a>
    <?php endif; ?>
<?php endif; ?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_telephone');  ?>


