<?php
/**
 * Template d'affichage de block dans une page fiche détaillée - bloc téléphone de contact
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3.21
 *
 */


BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_telephone', $ficheData);
if(BridgeBlockService::textBlockIsNotEmpty($fiche, $fiche->ficheBlocks, "telephone-s-de-contact")) :

            $itemIcon = '';
            $rendericon = '';
            $blocks_object = $fiche->ficheBlocks;
            $block_name = "telephone-s-de-contact";
            if(is_object($blocks_object) && property_exists($blocks_object, $block_name)) {
                $renderBlockData = $blocks_object->$block_name;
                if ( isset( $renderBlockData ) && is_object($renderBlockData->content) && !empty($renderBlockData->content->fields)) {
                    foreach($renderBlockData->content->fields as $index=>$section) {
                        $countitems = count($section->items);
                        if($countitems > 2) $countitems = 2;
                        echo '<div uk-grid class="uk-margin-bottom uk-grid-small uk-child-width-1-'. $countitems .'">';
                        foreach($section->items as $indexItem=>$item) {
                            $itemIcon = '';
                            // On récupère l'icon du titre
                            if (isset($item->iconClass) && is_object($item->iconClass) && !empty($item->iconClass->name)):
                                $itemIcon = BridgeUtils::renderIcon($item->iconClass);
                            endif;
                            // On récupère l'icon des éléments enfants qu'on affichera en mode column ou tags
                            if (isset($section->itemsIcons->name) && $section->itemsIcons->name != ''):
                                $rendericon = BridgeUtils::renderIcon($section->itemsIcons);
                            endif;

                            // Si l'élément inclu une image on l'ajoute
                            if (isset($item->image) && $item->image != ''):
                                $tmpOptions = BridgeUtils::getBridgeCredentials();
                                $urlBridge = $tmpOptions->urlBridge;
                                $urlImg = $urlBridge . '/media/' . $item->image;
                                if(BridgeBlockService::bridgeIsSvg($urlImg))
                                    $rendericon = BridgeBlockService::bridgeInlineSvg($urlImg);
                                else
                                    $rendericon = '<img src="' . $urlBridge . '/media/' . $item->image . '" height="30" alt="' . $item->label . '" title="' . $item->label . '" uk-tooltip />';
                            else :
                                if (!empty($itemIcon)):
                                    $rendericon = $itemIcon;
                                endif;
                                if (!empty($item->label)):
                                    $resSubItemLabel = '<span class="itemLabel"> ' . $item->label . '</span>';
                                else :
                                    $resSubItemLabel = '<span class="itemLabel"> ' .BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_APPELER', 'APPELER', 'plugin-sit') . '</span>';
                                endif;
                            endif;
                            ?>
                            <?php if(isset($item->textValue)): ?>
                                <?php $tel= $item->textValue; ?>
                                <div class="notranslate">
                                    <?php if ($ficheParameters->hidePhoneWithXX == true): ?>
                                        <a class="uk-button uk-width-1-1 uk-button-default phone phone<?= $indexItem; ?>  <?= (string) $fiche->ficheBlocks->{'telephone-s-de-contact'}->cssClass ?>" data-dnc-ttel="<?= $fiche->productCode ?>" data-product-code="<?= $fiche->productCode ?>" data-text-key="<?= (string) $fiche->productTextKey ?>" uk-toggle="target: .phone<?= $indexItem; ?>"><?= $rendericon. ' ' . $resSubItemLabel?></a>
                                        <a href="tel:<?= str_replace(' ','',$tel); ?>" class="uk-button uk-width-1-1 uk-button-default phone phone<?= $indexItem; ?> <?= (string) $fiche->ficheBlocks->{'telephone-s-de-contact'}->cssClass ?>" hidden ><?= $rendericon. ' ' . str_replace(', ',' - ',$tel); ?></a>
                                    <?php else: ?>
                                        <a href="tel:<?= str_replace(' ','',$tel); ?>" class="uk-button uk-width-1-1 uk-button-default phone phone<?= $indexItem; ?>  <?= (string) $fiche->ficheBlocks->{'telephone-s-de-contact'}->cssClass ?>"><?= $rendericon. ' ' . str_replace(', ',' - ',$tel); ?></a>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                            <?php

                        }
                        echo '</div>';
                    }

                }

            }

            ?>


<?php endif; ?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_telephone', $ficheData);  ?>


