<?php
/**
 * Template d'affichage d'une page fiche détaillée - modèle fiche itinéraire
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche
 *
 * @version 3.3
 *
 */

$htmlTitre = BridgeBlockService::renderNamedBlockHtml($fiche->ficheBlocks, 'titre-de-la-fiche');

?>

<div class="bridge-fiche fiche-itineraire" data-product-id="<?= $fiche->productCode; ?>" data-dnc-produit="<?= $fiche->productCode; ?>">
    <?= BridgeUtils::BridgeBreadcrumbs('|',BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_ACCUEIL', 'Accueil','plugin-sit'),1,'','') ?>

    <main class="content" id="detailfiche">
        <div class="uk-grid-collapse" uk-grid>
                <div class="uk-width-3-5@m" id="mainfiche">
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_header', $ficheData) ; ?>
                    <header class="entete uk-section-primary uk-text-center uk-section uk-padding-small">
                        <h1 class="uk-margin-remove bridge-titre-fiche <?= $classnotranslate ?>">
                            <?= $htmlTitre ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-ficheitineraire/classements-labels.php'); ?>
                        </h1>
                    </header>
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_header', $ficheData) ; ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-ficheitineraire/carousel-photos.php'); ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-ficheitineraire/infos-supplementaires-1.php'); ?>
                    <div class="uk-padding uk-section uk-section-default">
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/descriptif.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-2.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/onglets.php'); ?>
                    </div>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-3.php'); ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-4.php'); ?>
                </div>
                <aside class="uk-width-2-5@m uk-position-relative">
                    <div uk-sticky="end: #bridge-fiche-stop-sticky; offset: 20; media: 960;" class="uk-position-z-index">
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_top', $ficheData) ; ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-ficheitineraire/localisation.php'); ?>
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_after_map', $ficheData) ; ?>
                        <div class="uk-card uk-card-default uk-card-small">
                            <div class="uk-card-body uk-text-center">
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-ficheitineraire/elevation-data.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/coordonnees.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/reseaux-sociaux.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/telephone-s-de-contact.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/site-s-web.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/email-de-contact.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/lien-de-reservation-en-ligne.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-5.php'); ?>
                                <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_after_informations', $ficheData) ; ?>
                            </div>
                        </div>
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_bottom', $ficheData) ; ?>
                    </div>
                </aside>
                <div id="bridge-fiche-stop-sticky"></div>
            </div>
        </main>
    </div>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_end', $fiche) ; ?>
