<?php
/**
 * Template d'affichage d'une page fiche détaillée - modèle fiche 1
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche
 *
 * @version 3.3.0
 *
 */

$images = BridgeBlockService::extractPhotos($fiche->ficheBlocks, 'photos-medias');
$htmlTitre = BridgeBlockService::renderNamedBlockHtml($fiche->ficheBlocks, 'titre-de-la-fiche');

?>
<div class="bridge-fiche fiche-1" data-product-id="<?= $fiche->productCode; ?>" data-dnc-produit="<?= $fiche->productCode; ?>">
    <?php if (count($images) > 1) : ?>
        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_header') ; ?>
        <div class="uk-position-relative uk-visible-toggle" tabindex="-1" uk-slideshow="animation: fade;autoplay:true;ratio:false">
            <ul class="uk-slideshow-items" uk-height-viewport="offset-top: true">
                <?php $i = 0;
                foreach ($images as $image) : $i++; ?>
                    <li>
                        <img src="<?= BridgeUtils::getResizeImageLink($image->url, "tronq", "1600", "900", "60") ?>"
                             alt="<?php BridgeCmsAbstractLayer::esc_html($image->caption) ?>" uk-cover>
                        <div class="uk-position-center uk-position-small uk-text-center uk-light">
                            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_title') ; ?>
                            <?php if ($i == 1) : ?>
                                <h1 class="bridge-titre-fiche <?= $classnotranslate ?>"><?= $htmlTitre ?></h1>
                            <?php else : ?>
                                <span class="uk-h1 bridge-titre-fiche <?= $classnotranslate ?>"><?= $htmlTitre ?></span>
                            <?php endif; ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/classements-labels.php'); ?>
                            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_title') ; ?>
                        </div>
                    </li>
                <?php endforeach; ?>
            </ul>

            <div class="uk-light">
                <a class="uk-position-center-left uk-position-small uk-hidden-hover" href="#" uk-slidenav-previous uk-slideshow-item="previous"></a>
                <a class="uk-position-center-right uk-position-small uk-hidden-hover" href="#" uk-slidenav-next uk-slideshow-item="next"></a>
            </div>
        </div>
        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_header') ; ?>
    <?php else: ?>
        <?php $style = ""; ?>
        <?php if (!empty($images)) $style = 'background:url(' . BridgeUtils::getResizeImageLink($images[0]->url, "tronq", "1600", "900", "60") . ') no-repeat center center; background-size:cover;'; ?>
        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_header') ; ?>
        <header id="chapeau" class="uk-text-center uk-position-relative" uk-height-viewport="offset-top: true"
                style="<?= $style ?>">
                <div class="uk-position-center uk-position-small uk-text-center uk-light">
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_title') ; ?>
                    <h1><?= $htmlTitre ?></h1>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/classements-labels.php'); ?>
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_title') ; ?>
                </div>
                <?php if(!empty($images[0]->caption)): ?>
                    <span class="bridge-credit-photo uk-position-bottom-left">&copy; <?= str_replace(array('&copy; ','© '), array('',''),$images[0]->caption); ?></span>
                <?php endif; ?>
        </header>
        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_header') ; ?>
    <?php endif; ?>

    <main class="content uk-section uk-section-small" id="detailfiche">
        <div class="uk-container uk-container-center">
            <div uk-grid>
                <div class="uk-width-2-3@m uk-margin-top bridge-fiche-main" uk-grid >
                    <?php if ($ficheParameters->displayToc && $ficheParameters->tocPosition == 'GAUCHE'): ?>
                        <div class="uk-width-1-4@m uk-visible@m bridge-fiche-sommaire">
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/sommaire.php'); ?>
                        </div>
                    <?php endif; ?>
                    <?php if ($ficheParameters->displayToc): ?>
                        <div class="uk-width-3-4@m bridge-fiche-content">
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-1.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/pictogrammes.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/descriptif.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/onglets.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-2.php'); ?>
                        </div>
                    <?php else: ?>
                        <div class="uk-width-1-1 uk-padding bridge-fiche-content">
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-1.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/pictogrammes.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/descriptif.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/onglets.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-2.php'); ?>
                        </div>
                    <?php endif; ?>
                    <?php if ($ficheParameters->displayToc && $ficheParameters->tocPosition == 'DROITE'): ?>
                        <div class="uk-width-1-4@m uk-visible@m bridge-fiche-sommaire">
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/sommaire.php'); ?>
                        </div>
                    <?php endif; ?>
                </div>
                <aside class="uk-width-1-3@m uk-position-relative bridge-fiche-aside">
                    <div uk-sticky="end: #bridge-fiche-stop-sticky; offset: 20; media: 960;" class="uk-position-z-index">
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_top', $ficheData) ; ?>
                        <div class="uk-card uk-card-default uk-card-small">
                            <div class="uk-card-media-top">
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/localisation.php'); ?>
                                <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_after_map', $ficheData) ; ?>
                            </div>
                            <div class="uk-card-body uk-text-center">
                                <h3 class="uk-h5 uk-text-bold"><?= $fiche->name; ?></h3>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/coordonnees.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/reseaux-sociaux.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/telephone-s-de-contact.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/site-s-web.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/email-de-contact.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/lien-de-reservation-en-ligne.php'); ?>
                                <?php if ($ficheParameters->displayCvButton): ?>
                                    <div class="uak-position-z-index bridge-cv-button-container">
                                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/button-cv.php'); ?>
                                    </div>
                                <?php endif; ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-5.php'); ?>
                                <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_after_informations', $ficheData) ; ?>
                            </div>

                        </div>
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_bottom', $ficheData) ; ?>
                    </div>
                </aside>
            </div>
        </div>
    </main>
    <div id="bridge-fiche-stop-sticky" class="uk-width-1-1 uk-height-small"></div>
    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-3.php'); ?>
    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-4.php'); ?>

</div>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_end',$fiche) ; ?>
