<?php
/**
 * Template d'affichage d'une page fiche détaillée - modèle fiche 2
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche
 *
 * @version 3.3
 *
 */
?>
<div class="bridge-fiche fiche-2" data-product-id="<?= $fiche->productCode; ?>" data-dnc-produit="<?= $fiche->productCode; ?>">
    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_header', $ficheData) ; ?>
    <header id="chapeau" class="uk-container uk-container-center uk-text-center">
        <h1 class="bridge-titre-fiche <?= $classnotranslate ?>"><?= $fiche->name; ?></h1>
        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/classements-labels.php'); ?>
    </header>
    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_header', $ficheData) ; ?>

    <main class="content uk-section" id="detailfiche">
        <div class="uk-container uk-container-center ">
            <div uk-grid class="bridge-fiche-details uk-position-relative" >
                <div class="uk-width-2-3@m bridge-fiche-main">
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/photos.php'); ?>
                    <div class="uk-margin-top" uk-grid>
                        <?php if ($ficheParameters->displayToc && $ficheParameters->tocPosition == 'GAUCHE'): ?>
                            <div class="uk-width-1-4@m uk-visible@m bridge-fiche-sommaire">
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/sommaire.php'); ?>
                            </div>
                        <?php endif; ?>
                        <?php if ($ficheParameters->displayToc): ?>
                            <div class="uk-width-3-4@m bridge-fiche-content">
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-1.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/pictogrammes.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/descriptif.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/onglets.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-2.php'); ?>
                            </div>
                        <?php else: ?>
                            <div class="uk-width-1-1 uk-padding bridge-fiche-content">
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-1.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/pictogrammes.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/descriptif.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/onglets.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-2.php'); ?>
                            </div>
                        <?php endif; ?>
                        <?php if ($ficheParameters->displayToc && $ficheParameters->tocPosition == 'DROITE'): ?>
                            <div class="uk-width-1-4@m uk-visible@m bridge-fiche-sommaire">
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/sommaire.php'); ?>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
                <aside class="uk-width-1-3@m bridge-fiche-aside" style="display:block; position:relative;">
                    <div uk-sticky="end: #bridge-fiche-stop-sticky; offset: 20; media: 960;" class="uk-position-z-index">
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_top', $ficheData) ; ?>
                        <div class="uk-card uk-card-default uk-card-small">
                            <div class="uk-card-media-top">
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/localisation.php'); ?>
                                <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_after_map') ; ?>
                            </div>
                            <div class="uk-card-body uk-text-center uk-position-relative">
                                <h3 class="uk-h5 uk-text-bold"><?= $fiche->name; ?></h3>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/coordonnees.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/reseaux-sociaux.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/telephone-s-de-contact.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/site-s-web.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/email-de-contact.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/lien-de-reservation-en-ligne.php'); ?>
                                <?php if($ficheParameters->displayCvButton): ?>
                                    <div class="uk-position-z-index">
                                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/button-cv.php'); ?>
                                    </div>
                                <?php endif; ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-5.php'); ?>
                                <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_after_informations', $ficheData) ; ?>
                            </div>
                        </div>
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_bottom', $ficheData) ; ?>
                    </div>
                </aside>
            </div>
        </div>
    </main>
    <div id="bridge-fiche-stop-sticky" class="uk-width-1-1 uk-height-small"></div>
    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-3.php'); ?>
    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-4.php'); ?>
</div>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_end',$fiche) ; ?>
