<?php
/**
 * Template d'affichage d'une page fiche détaillée - modèle fiche 3
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche
 *
 * @version 3.3
 *
 */


$images = BridgeBlockService::extractPhotos($fiche->ficheBlocks, 'photos-medias');

// On traite la donnée block Custom poru l'avoir hiérarchisée
$hierarchicalCustomBlocks = array();
if(isset($fiche) && is_object($fiche) && !empty($fiche->ficheBlocks) && isset($fiche->ficheBlocks->custom) && count($fiche->ficheBlocks->custom) > 0) {
    $hierarchicalCustomBlocks = BridgeBlockService::prepareCustomBlocksDisplay($fiche, $fiche->ficheBlocks->custom, $ficheParameters);
}
$htmlTitre = BridgeBlockService::renderNamedBlockHtml($fiche->ficheBlocks, 'titre-de-la-fiche');

?>
<div class="bridge-fiche fiche-3" data-product-id="<?= $fiche->productCode; ?>" data-dnc-produit="<?= $fiche->productCode; ?>">
    <?php if (count($images) > 1) : ?>
        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_header', $ficheData) ; ?>
        <div class="uk-position-relative uk-visible-toggle" tabindex="-1" uk-slideshow="animation: fade; ratio: 8:3">

            <ul class="uk-slideshow-items">
                <?php $i = 0;
                foreach ($images as $image) : $i++; ?>
                    <li>
                        <img src="<?= BridgeUtils::getResizeImageLink($image->url, "tronq", "1600", "900", "60") ?>"
                             alt="<?php BridgeCmsAbstractLayer::esc_html($image->caption) ?>" uk-cover>
                        <div class="uk-position-bottom uk-position-small uk-text-center uk-light">
                            <?php if ($i == 1) : ?>
                                <h1 class="bridge-titre-fiche <?= $classnotranslate ?>"><?= $htmlTitre ?></h1>
                            <?php else : ?>
                                <span class="uk-h1 bridge-titre-fiche <?= $classnotranslate ?>"><?= $htmlTitre ?></span>
                            <?php endif; ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/classements-labels.php'); ?>
                        </div>
                    </li>
                <?php endforeach; ?>
            </ul>

            <div class="uk-light">
                <a class="uk-position-center-left uk-position-small uk-hidden-hover" href="#" uk-slidenav-previous
                   uk-slideshow-item="previous"></a>
                <a class="uk-position-center-right uk-position-small uk-hidden-hover" href="#" uk-slidenav-next
                   uk-slideshow-item="next"></a>
            </div>
        </div>
        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_header', $ficheData) ; ?>
    <?php else: ?>
        <?php $style = ""; ?>
        <?php if (!empty($images)) $style = 'background:url(' . BridgeUtils::getResizeImageLink($images[0]->url, "tronq", "1600", "900", "60") . ') no-repeat center center; background-size:cover;'; ?>
        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_header') ; ?>
        <header id="chapeau" class="uk-text-center uk-position-relative" uk-height-viewport="offset-top: true"
                style="<?= $style ?>">
            <div class="uk-position-bottom uk-position-small uk-text-center uk-light">
                <h1 class="<?= $classnotranslate ?>"><?= $htmlTitre ?></h1>
                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/classements-labels.php'); ?>
            </div>
        </header>
        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_header', $ficheData) ; ?>
    <?php endif; ?>

    <main class="content uk-section uk-section-small" id="detailfiche">
        <div class="uk-container uk-container-center">
            <div class="uk-margin-medium-top bridge-fiche-main">
                <ul class="uk-flex-center bridge-fiche-sommaire" uk-tab>
                    <li class="uk-active"><a href="#"><i class="fa fa-info"></i><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_DESCRIPTIF', 'Descriptif', 'plugin-sit') ?></a>
                    </li>
                    <?php if (count($hierarchicalCustomBlocks) > 0) : ?>
                        <?php foreach ($hierarchicalCustomBlocks as $onglet) : ?>
                            <li><a href="#"><?= $onglet->title; ?></a></li>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </ul>
                <ul class="uk-switcher uk-margin bridge-fiche-content">
                    <li>
                        <div uk-grid class="uk-grid-divider">
                            <div class="uk-width-2-3@m">
                                <h2 class="uk-heading-line"><span><?= $htmlTitre ?></span></h2>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/descriptif.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-1.php'); ?>
                            </div>
                            <div class="uk-width-1-3@m">
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/pictogrammes.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-2.php'); ?>
                            </div>
                        </div>
                    </li>

                    <?php if (count($hierarchicalCustomBlocks) > 0) : ?>
                        <?php foreach ($hierarchicalCustomBlocks as $onglet) : ?>
                            <li id="custom-block-<?= $onglet->blockId ?>" class="custom-block">
                                <?php $i = 0; ?>
                                <?php foreach ($onglet->items as $item): ?>
                                    <?php if ($i > 0): ?>
                                        <hr class="block-separator uk-divider-icon"/>
                                    <?php endif; ?>
                                    <?php if (!empty($item->title)): ?>
                                        <h3 class="block-label uk-h2"><span><?= $item->title ?></span></h3>
                                    <?php endif; ?>

                                    <?php if (!empty($item->component)): ?>
                                        <?php $blockData = $item->blockData; ?>
                                        <?php  include BridgeUtils::bridge_locate_template('templates-bridge/fiche/gabarits/' . $item->component . '.php'); ?>
                                    <?php else: ?>
                                        <?= $item->html; ?>
                                    <?php endif; ?>


                                    <?php $i++; ?>
                                <?php endforeach; ?>
                            </li>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </main>

    <div class="uk-section uk-section-secondary uk-padding-remove" id="localisation">
        <div class="uk-grid-collapse uk-flex-middle" uk-grid>
            <div class="uk-width-1-2@m">
                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche3/localisation.php'); ?>
            </div>
            <div class="uk-width-1-2@m">
                <div class="uk-padding">
                    <h3 class="uk-h5 uk-text-bold uk-heading-line"><span><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_COORDONNEES', 'Coordonnées', 'plugin-sit'); ?></span></h3>
                    <ul class="uk-list uk-list-divider uk-list-large">
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche3/coordonnees.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche3/telephone-s-de-contact.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche3/site-s-web.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche3/email-de-contact.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche3/lien-de-reservation-en-ligne.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/reseaux-sociaux.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-5.php'); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-3.php'); ?>
    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-4.php'); ?>
</div>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_end',$fiche) ; ?>
