<?php
/**
 * Template d'affichage d'une page fiche détaillée - modèle fiche 2
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche
 *
 * @version 3.3.21
 *
 */
$htmlTitre = BridgeBlockService::renderNamedBlockHtml($fiche->ficheBlocks, 'titre-de-la-fiche');
?>
<div class="bridge-fiche fiche-4" data-product-id="<?= $fiche->productCode; ?>" data-dnc-produit="<?= $fiche->productCode; ?>">
    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_header', $ficheData) ; ?>
    <header id="chapeau" class="uk-container uk-container-center uk-text-center uk-section uk-padding-remove-bottom">
        <div class="uk-flex uk-flex-center">
            <h1 class="bridge-titre-fiche <?= $classnotranslate ?>"><?= $htmlTitre; ?></h1>
            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/classements-labels.php'); ?>
        </div>
    </header>
    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_header', $ficheData) ; ?>

    <main class="content" id="detailfiche">
        <div class="uk-container uk-container-center">
            <div class="medias uk-section uk-section-small uk-padding-remove-bottom">
                <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_medias', $ficheData) ; ?>
                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche4/photos.php'); ?>
                <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_medias', $ficheData) ; ?>
            </div>
            <div class="uk-section uk-padding-left uk-padding" uk-grid>
                <div class="uk-width-2-3@m bridge-fiche-main">
                    <div class="uk-margin-top" uk-grid>
                       <div class="bridge-fiche-content">
                            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_content', $ficheData) ; ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-1.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche4/descriptif.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche4/onglets.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-2.php'); ?>
                            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_content', $ficheData) ; ?>
                       </div>
                    </div>
                </div>
                <aside class="uk-width-1-3@m bridge-fiche-aside">
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_top', $ficheData) ; ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-3.php'); ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/pictogrammes.php'); ?>
                    <div class="uk-card uk-card-default uk-card-small  uk-margin">
                        <div class="uk-card-body uk-text-center uk-position-relative">
                            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_after_informations', $ficheData) ; ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/coordonnees.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/telephone-s-de-contact.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/site-s-web.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/email-de-contact.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/lien-de-reservation-en-ligne.php'); ?>
                            <?php if($ficheParameters->displayCvButton): ?>
                                <div class="uk-position-z-index">
                                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/button-cv.php'); ?>
                                </div>
                            <?php endif; ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/reseaux-sociaux.php'); ?>
                            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_after_informations', $ficheData) ; ?>
                        </div>
                    </div>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-4.php'); ?>
                    <div class="uk-margin">
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_after_map', $ficheData) ; ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche4/localisation.php'); ?>
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_after_map', $ficheData) ; ?>
                    </div>

                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_bottom', $ficheData) ; ?>
                </aside>
            </div>
            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-5.php'); ?>
        </div>
    </main>
    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_all', $ficheData) ; ?>
</div>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_end',$fiche) ; ?>
