<?php

/**
 * Template d'affichage d'une page fiche détaillée - modèle fiche 6
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche
 *
 * @version 3.5.21
 *
 */
$htmlTitre = BridgeBlockService::renderNamedBlockHtml($fiche->ficheBlocks, 'titre-de-la-fiche');
?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_start',$ficheData) ; ?>
<div class="bridge-fiche fiche-6" data-product-id="<?= $fiche->productCode; ?>" data-dnc-produit="<?= $fiche->productCode; ?>">

    <main class="content uk-section bridge-fiche-details" id="detailfiche">
        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before',$ficheData) ; ?>
        <header class="headerfiche uk-width-1-1">
            <div uk-grid class="uk-flex-middle">
                <div class="uk-width-1-2@m"><?= BridgeUtils::BridgeBreadcrumbs('|',BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_ACCUEIL', 'Accueil','plugin-sit'),1,'','') ?></div>
                <div class="uk-width-1-2@m actions">
                    <?php if($ficheParameters->displayCvButton): ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/button-cv.php'); ?>
                    <?php endif; ?>
                    <?php /*if($ficheParameters->displayShareButton): ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/share.php'); ?>
                    <?php endif;*/  ?>
                </div>
            </div>
        </header>

        <section id="bridge-hero-6" class="bridge-hero">

            <div uk-grid class="uk-flex uk-flex-middle uk-flex-center">
                <div class="uk-width-2-5@m bridge-fiche-main">

                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-1.php'); ?>
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_header', $ficheData) ; ?>
                    <header id="chapeau" class="uk-text-left">
                        <h1 class="bridge-titre-fiche <?= $classnotranslate ?>"><?= (!empty($htmlTitre)) ? $htmlTitre : $fiche->name; ?></h1>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/classements-labels.php'); ?>
                    </header>
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_header', $ficheData) ; ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-2.php'); ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche6/descriptif.php'); ?>

                    <div id="zone-contact">
                        <div class="uk-flex uk-flex-auto uk-flex-middle uk-grid-small uk-width-1-1 uk-flex-between" uk-grid>
                            <div class="uk-width-1-2@m"><?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-3.php'); ?></div>
                            <div class="zone-coordonnees uk-width-1-2@m">
                                <div uk-grid class="uk-grid-small uk-grid-match uk-flex-stretch">
                                    <a class="bouton bridge-bouton-carto" href="#fiche-coordonnees" uk-slide="offset:200">
                                        <i class="fa fa-map"></i><span>Carte</span>
                                    </a>
                                    <div class="bouton bridge-bouton-contact uk-width-auto@s" uk-toggle="target: #contact-box" role="button">
                                        <i class="fa fa-envelope"></i><span>Contact</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="uk-width-3-5@m">
                    <div class="zone-illustrations uk-position-relative">
                        <div class="uk-position-top-left zone-actions">

                        </div>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche6/photos.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/pictogrammes.php'); ?>
                    </div>
                </div>

                <div uk-grid class="uk-flex-center">
                    <div class="uk-width-expand uk-text-center">
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/lien-de-reservation-en-ligne.php'); ?>
                    </div>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-4.php'); ?>
                </div>
            </div>
        </section>
        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche6_after_hero',$ficheData) ; ?>
        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche6_before_contenu',$ficheData) ; ?>
        <section class="uk-margin-top" id="bridge-contenu">
            <?php if ($ficheParameters->displayToc): ?>
                <div class="uk-width-1-1 uk-visible@m bridge-fiche-sommaire uk-position-z-index uk-text-center" uk-sticky="end: #bridge-fiche-stop-sticky; offset: 100; media: 960;">
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche6/sommaire.php'); ?>
                </div>
            <?php endif; ?>
            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche6/onglets.php'); ?>
        </section>
        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche6_after_contenu',$ficheData) ; ?>
        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche6_before_bottom_informations',$ficheData) ; ?>
        <section class="uk-margin-top bridge-coordonnees" id="fiche-coordonnees">
            <div uk-grid class="uk-flex-middle">
                <div class="uk-width-1-2@m">
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche6_before_coordonnees',$ficheData) ; ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/coordonnees.php'); ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche6/telephone-s-de-contact.php'); ?>
                    <div class="actions uk-flex">
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche6_before_coordonnees_actions', $ficheData) ; ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche6/site-s-web.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche6/email-de-contact.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/lien-de-reservation-en-ligne.php'); ?>
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche6_after_coordonnees_actions', $ficheData) ; ?>
                    </div>
                     <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/reseaux-sociaux.php'); ?>
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche6_after_coordonnees', $ficheData) ; ?>
                </div>
                <div class="uk-width-1-2@m">
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche6_before_map',$ficheData) ; ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche6/localisation.php'); ?>
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche6_after_map',$ficheData) ; ?>
                </div>
            </div>
        </section>
        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche6_after_bottom_informations',$ficheData) ; ?>
        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-5.php'); ?>
    </main>
    <div id="bridge-fiche-stop-sticky" class="uk-width-1-1 uk-height-small"></div>
</div>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_end',$ficheData) ; ?>

<div id="contact-box" uk-modal role="dialog" aria-modal="true" aria-labelledby="info-contact-box" class="uk-flex-top">
    <div class="uk-modal-dialog uk-modal-body uk-margin-auto-vertical">
        <button class="uk-modal-close-default" type="button" aria-label="Fermé" uk-close></button>
        <div class="content">
            <h2 id="info-contact-box" class="uk-modal-title">Coordonnées</h2>
            <div class="infos">
                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche6/modal-contact/coordonnees.php'); ?>
                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche6/modal-contact/telephone-s-de-contact.php'); ?>
                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche6/modal-contact/email-de-contact.php'); ?>
                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche6/modal-contact/site-s-web.php'); ?>
            </div>
        </div>
    </div>
</div>
