<?php
/**
 * Template d'affichage d'une page fiche détaillée - modèle fiche 7
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche
 *
 * @version 3.3
 *
 */
?>
<div class="bridge-fiche fiche-7" data-product-id="<?= $fiche->productCode; ?>" data-dnc-produit="<?= $fiche->productCode; ?>">
    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_main', $ficheData) ; ?>
    <main class="content uk-section" id="detailfiche">
        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_container', $ficheData) ; ?>
        <div class="uk-container uk-container-center ">
            <div uk-grid class="bridge-fiche-details uk-position-relative">
                <div class="uk-width-2-3@s bridge-fiche-main">
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_photos', $ficheData) ; ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/photos.php'); ?>
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_photos', $ficheData) ; ?>

                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_infos_supp_5', $ficheData) ; ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-4.php'); ?>
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_infos_supp_4', $ficheData) ; ?>

                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_pictogrammes', $ficheData) ; ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/pictogrammes.php'); ?>
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_pictogrammes', $ficheData) ; ?>

                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_descriptif', $ficheData) ; ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/descriptif.php'); ?>
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_descriptif', $ficheData) ; ?>

                    <div class="uk-margin-top">
                        <?php if ($ficheParameters->displayToc): ?>
                            <div class="bridge-fiche-sommaire">
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/sommaire.php'); ?>
                            </div>
                        <?php endif; ?>
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_onglets', $ficheData) ; ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/onglets.php'); ?>
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_onglets', $ficheData) ; ?>
                    </div>
                </div>

                <aside class="uk-width-1-3@s bridge-fiche-aside" style="display:block; position:relative;">
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_top', $ficheData) ; ?>
                    <h1 class="bridge-titre-fiche <?= $classnotranslate ?>"><?= BridgeBlockService::renderNamedBlockHtml($fiche->ficheBlocks, 'titre-de-la-fiche'); ?></h1>
                    <?php if($ficheParameters->displayCvButton): ?>
                        <div class="uk-position-z-index">
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/button-cv.php'); ?>
                        </div>
                    <?php endif; ?>
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_before_infos_supp_2', $ficheData) ; ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-1.php'); ?>
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_after_infos_supp_2', $ficheData) ; ?>

                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_before_labels', $ficheData) ; ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/classements-labels.php'); ?>
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_after_labels', $ficheData) ; ?>

                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_before_infos_pratiques', $ficheData) ; ?>
                    <!-- Infos pratiques -->
                    <section class="uk-card uk-card-default uk-card-body uk-margin-small-bottom bridge_infos_pratiques">
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_title_infos_pratiques', $ficheData) ; ?>
                        <!-- <h2 class="uk-card-title uk-margin-small-bottom">Infos pratiques</h2> -->
                        <ul class="uk-description-list">
                            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_begin_infos_pratiques', $ficheData) ; ?>

                            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_before_infos_supp_2', $ficheData) ; ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-2.php'); ?>
                            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_after_infos_supp_2', $ficheData) ; ?>

                            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_before_coordonnees', $ficheData) ; ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche7/coordonnees.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche7/telephone-s-de-contact.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche7/site-s-web.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche7/email-de-contact.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/reseaux-sociaux.php'); ?>
                            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_after_coordonnees', $ficheData) ; ?>

                            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_end_infos_pratiques', $ficheData) ; ?>
                        </ul>
                    </section>
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_after_infos_pratiques', $ficheData) ; ?>

                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_before_booking_link', $ficheData) ; ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/lien-de-reservation-en-ligne.php'); ?>
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_after_booking_link', $ficheData) ; ?>

                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_before_infos_supp_3', $ficheData) ; ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-3.php'); ?>
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_after_infos_supp_3', $ficheData) ; ?>

                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_before_map', $ficheData) ; ?>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche7/localisation.php'); ?>
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_after_map', $ficheData) ; ?>
                </aside>
            </div>
            <div id="bridge-fiche-stop-sticky" class="uk-width-1-1 uk-height-small"></div>
            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_infos_supp_5', $ficheData) ; ?>
            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-5.php'); ?>
            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_infos_supp_5', $ficheData) ; ?>
        </div>
        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_container', $ficheData) ; ?>
    </main>
    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_main', $ficheData) ; ?>
</div>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_end', $ficheData) ; ?>
