<?php
/**
 * Template d'affichage d'une page fiche détaillée - modèle fiche shortcode
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche
 *
 * @version 3.3
 *
 */
$htmlTitre = BridgeBlockService::renderNamedBlockHtml($fiche->ficheBlocks, 'titre-de-la-fiche');
$blocksContactGauche = ['coordonnees-contact', 'reseaux-sociaux'];
$blocksContactDroite = ['telephone-s-de-contact', 'site-s-web', 'email-de-contact', 'lien-de-reservation-en-ligne'];
$noContactGauche = true;
$noContactDroite = true;
foreach ($blocksContactGauche as $blockContact) {
    if (BridgeBlockService::blockIsNotEmpty($fiche, $fiche->ficheBlocks->$blockContact)) {
	    $noContactGauche = false;
    }
}
foreach ($blocksContactDroite as $blockContact) {
    if (BridgeBlockService::blockIsNotEmpty($fiche, $fiche->ficheBlocks->$blockContact)) {
	    $noContactDroite = false;
    }
}
?>
<div class="bridge-fiche fiche-shortcode" data-product-id="<?= $fiche->productCode; ?>" data-dnc-produit="<?= $fiche->productCode; ?>">
    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_header', $ficheData) ; ?>
    <?php if (BridgeBlockService::textBlockIsNotEmpty($fiche, $fiche->ficheBlocks, 'titre-de-la-fiche') || BridgeBlockService::itemsBlockIsNotEmpty($fiche, $fiche->ficheBlocks, 'classements-labels') || BridgeBlockService::itemsBlockIsNotEmpty($fiche, $fiche->ficheBlocks, 'pictogrammes')): ?>
        <header id="chapeau" class="uk-container uk-container-center uk-text-center">
	        <?php if (BridgeBlockService::textBlockIsNotEmpty($fiche, $fiche->ficheBlocks, 'titre-de-la-fiche') || BridgeBlockService::itemsBlockIsNotEmpty($fiche, $fiche->ficheBlocks, 'classements-labels')): ?>
                <div class="uk-flex uk-flex-center uk-flex-middle">
                    <h1 class="bridge-titre-fiche <?= $classnotranslate ?>"><?= $htmlTitre; ?></h1>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/classements-labels.php'); ?>
                </div>
            <?php endif; ?>
	        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/pictogrammes.php'); ?>
        </header>
    <?php endif; ?>
    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_header', $ficheData) ; ?>

    <main class="content" id="detailfiche">
        <div class="uk-container uk-container-center">
	        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/photos.php'); ?>
	        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-1.php'); ?>
	        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/descriptif.php'); ?>
	        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-2.php'); ?>
	        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/onglets.php'); ?>
	        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-3.php'); ?>

            <?php if (($noContactGauche === false || $ficheParameters->displayCvButton) && $noContactDroite === false): ?>
                <div uk-grid class="bridge-fiche-contact">
                    <div class="uk-width-1-2@m">
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/coordonnees.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/reseaux-sociaux.php'); ?>
                        <?php if($ficheParameters->displayCvButton): ?>
                            <div class="uk-position-z-index">
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/button-cv.php'); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="uk-width-1-2@m">
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/telephone-s-de-contact.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/site-s-web.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/email-de-contact.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/lien-de-reservation-en-ligne.php'); ?>
                    </div>
                </div>
            <?php elseif (($noContactGauche === false || $ficheParameters->displayCvButton) || $noContactDroite === false): ?>
                <div class="bridge-fiche-contact">
                    <?php if($noContactGauche === false || $ficheParameters->displayCvButton): ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/coordonnees.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/reseaux-sociaux.php'); ?>
                        <?php if($ficheParameters->displayCvButton): ?>
                            <div class="uk-position-z-index">
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/button-cv.php'); ?>
                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/telephone-s-de-contact.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/site-s-web.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/email-de-contact.php'); ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/lien-de-reservation-en-ligne.php'); ?>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

	        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-4.php'); ?>
	        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-5.php'); ?>
        </div>
    </main>
</div>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_end',$fiche) ; ?>
