<?php
/**
 * Template d'affichage d'une page fiche détaillée - modèle fiche shortcode
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche
 *
 * @version 3.2
 *
 */
$htmlTitre = BridgeBlockService::renderNamedBlockHtml($fiche->ficheBlocks, 'titre-de-la-fiche');
$blocksContactGauche = ['coordonnees-contact', 'reseaux-sociaux'];
$blocksContactDroite = ['telephone-s-de-contact', 'site-s-web', 'email-de-contact', 'lien-de-reservation-en-ligne'];
$noContactGauche = true;
$noContactDroite = true;
foreach ($blocksContactGauche as $blockContact) {
    if (BridgeBlockService::blockIsNotEmpty($fiche, $fiche->ficheBlocks->$blockContact)) {
        $noContactGauche = false;
    }
}
foreach ($blocksContactDroite as $blockContact) {
    if (BridgeBlockService::blockIsNotEmpty($fiche, $fiche->ficheBlocks->$blockContact)) {
        $noContactDroite = false;
    }
}
?>
<div class="bridge-fiche fiche-shortcode2" data-product-id="<?= $fiche->productCode; ?>" data-dnc-produit="<?= $fiche->productCode; ?>" id="infos-pratiques">
    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_header',$ficheData) ; ?>
    <?php if (BridgeBlockService::textBlockIsNotEmpty($fiche, $fiche->ficheBlocks, 'titre-de-la-fiche') || BridgeBlockService::itemsBlockIsNotEmpty($fiche, $fiche->ficheBlocks, 'classements-labels') || BridgeBlockService::itemsBlockIsNotEmpty($fiche, $fiche->ficheBlocks, 'pictogrammes')): ?>
        <header id="chapeau" class="uk-container uk-container-center uk-text-center">
            <?php if (BridgeBlockService::textBlockIsNotEmpty($fiche, $fiche->ficheBlocks, 'titre-de-la-fiche') || BridgeBlockService::itemsBlockIsNotEmpty($fiche, $fiche->ficheBlocks, 'classements-labels')): ?>
                <div class="uk-flex uk-flex-center uk-flex-middle">
                    <h1 class="bridge-titre-fiche <?= $classnotranslate ?>"><?= $htmlTitre; ?></h1>
                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/classements-labels.php'); ?>
                </div>
            <?php endif; ?>
            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/pictogrammes.php'); ?>
        </header>
    <?php endif; ?>
    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_header',$ficheData) ; ?>

    <main class="content detailfiche">
        <div class="uk-container uk-container-center bridge-container">
            
             <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/photos.php'); ?>
            
             <section class="uk-margin-top bridge-coordonnees" id="fiche-coordonnees">            
                    <div uk-grid class="uk-flex-middle">
                        <div class="uk-width-1-2@m">
                            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_ficheshortcode2_before_map',$ficheData) ; ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks-fiche6/localisation.php'); ?>
                            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_ficheshortcode2_after_map',$ficheData) ; ?>
                        </div>
                        <div class="uk-width-1-2@m">
                            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_ficheshortcode2_before_coordonnees',$ficheData) ; ?>
                            
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-1.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/descriptif.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-2.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/onglets.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-3.php'); ?>
                            
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/coordonnees.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/telephone-s-de-contact.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/reseaux-sociaux.php'); ?>

                            <div class="actions uk-flex">
                                <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_ficheshortcode2_before_actions',$ficheData) ; ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/site-s-web.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/email-de-contact.php'); ?>
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/lien-de-reservation-en-ligne.php'); ?>
                                <?php if($ficheParameters->displayCvButton): ?>
                                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/button-cv.php'); ?>
                                <?php endif; ?>
                                <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_ficheshortcode2_after_actions',$ficheData) ; ?>
                            </div>
                            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_ficheshortcode2_after_coordonnees',$ficheData) ; ?>
                        </div>

                    </div>
                </section>
    
            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-4.php'); ?>
            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-5.php'); ?>

        </div>
    </main>
</div>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_end',$ficheData) ; ?>
