<?php
/**
 * Template d'affichage composant socialbox facebook
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/gabarits
 *
 * @version 3.3
 *
 */

$meta = '';
if(BridgeBlockService::textBlockDataIsNotEmpty($fiche, $blockData))
    $meta = BridgeBlockService::extractBlockFirstTextValue ( $blockData);

// [{"cible":"general","metadonnee":{"id":5773060,"entity":728}}]

$data = '';
$entity = '';
$id = '';

if(!empty($meta)) {
// [{"cible":"general","metadonnee":{"id":5773060,"entity":728}}]
    $data = json_decode($meta);
    if(is_array($data) && count($data) > 0 && isset($data[0]->metadonnee) && is_object($data[0]->metadonnee) && isset($data[0]->metadonnee->id) && isset($data[0]->metadonnee->entity)) {
        $entity = $data[0]->metadonnee->entity;
        $id = $data[0]->metadonnee->id;
    }
}


if(!empty($entity) && !empty($id)):
// [{"cible":"general","metadonnee":{"id":5773060,"entity":728}}]
    // echo "entity $entity id $id";
    switch(BridgeUtils::getLanguage()):
        case 'en':
            $lang = 1;
            break;
        case 'de':
            $lang = 2;
            break;
        case 'nl':
            $lang = 3;
            break;
        case 'es':
            $lang = 4;
            break;
        case 'it':
            $lang = 5;
            break;
        case 'fr':
            $lang = 6;
            break;
    endswitch;
    ?>

<?php // On défini le nombre de mois à afficher
$nbmois = 2; ?>

    <section class="uk-margin-bottom uk-sectiona auk-container">
        <script type="text/javascript">
            // <!--
            function resizewidgetdispos() {
                document.getElementById('widgetdispos').style.height =  document.getElementById('myFrameWidgetDispos').contentWindow.document.getElementById('total').clientHeight + 10 + 'px';
                document.getElementById('widgetdispos').style.overflow = 'hidden';
                window.onresize = function(event) {
                    document.getElementById('widgetdispos').style.height =  document.getElementById('myFrameWidgetDispos').contentWindow.document.getElementById('total').scrollHeight + 10 +'px';
                    document.getElementById('widgetdispos').style.overflow = 'hidden';
                };
            }
            jQuery(document).ready(function($j) {
                UIkit.util.on('#tabs-sit > .dispos','beforeshow', function(){
                    resizewidgetdispos();
                });
            });
            // -->
        </script>
        <div id='widgetdispos'>
            <iframe onload='resizewidgetdispos();' id='myFrameWidgetDispos' src='/index.php?dispos-avizi=1&avizi_entity=<?= $entity ?>&avizi_id=<?= $id ?>&avizi_lang=<?= $lang; ?>&nbmois=<?= $nbmois; ?>' style='height: 800px;' width='100%' scrolling='auto' frameborder='0'></iframe>
            <?php /* <iframe onload='resizewidgetdispos();' id='myFrameWidgetDispos' src='https://app.avizi.fr/disponibilites/public/<?= $entity ?>/<?= $id ?>&consult=a5a5a5&libre=abc638&complet=cc4a4a&fermer=000000&langue=<?= $lang; ?>' style='height: 800px;' width='100%' scrolling='auto' frameborder='0'></iframe> */ ?>
        </div>
        <div class="uk-text-center">
            <a class="uk-link-text" href="https://app.avizi.fr/disponibilites/public/<?= $entity ?>/<?= $id ?>?lang=<?= $lang; ?>&date=<?= date('d/m/Y'); ?>" target="_blank"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_VOIR_MOIS_SUIVANTS','Voir les mois suivants','plugin-sit') ?></a>
        </div>
    </section>

<?php endif; ?>
