<?php
/**
 * Template d'affichage de fiches à proximité dans une page fiche détaillée
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/gabarits
 *
 * @version 3.3.11
 *
 */
$devDN = (isset($_REQUEST['ddd']) && $_REQUEST['ddd'] == '1');

$nbCriteresCapacite = 0;
$nomSalleCriterion = null;
$hasNameDefined = false;
$hasAtLEastOneCapaciteDefined = false;
$capacitesProps = ['nomSalle','superficie','capaciteCocktail','capaciteAmphi','capaciteClasse','capaciteEnu','capaciteReunion','capaciteBanquet'];
$capacitesLibelles = [
        'superficie' => 'Surface en m²',
        'capaciteCocktail' => 'Capacité en cocktail',
        'capaciteAmphi' => 'Capacité en théâtre',
        'capaciteClasse' => 'Capacité en classe',
        'capaciteEnu' => 'Capacité en U',
        'capaciteReunion' => 'Capacité en réunion',
        'capaciteBanquet' => 'Capacité en banquet'
    ];
$capacitesCriterions = [];
$nbTotalCriteresCapacite = count($capacitesProps) - 1;

// if($devDN) {
    // print_r($blockData->parameters);
    if(is_object($blockData) && isset($blockData->parameters) && is_object($blockData->parameters)) {
        if (isset($blockData->parameters->nomSalleCriterion) && !empty($blockData->parameters->nomSalleCriterion)) {
            $nomSalleCriterion = $blockData->parameters->nomSalleCriterion;
        }

        foreach($capacitesProps as $capaciteProp) {
            $capaciteProp2 = $capaciteProp . 'Criterion';
            if (isset($blockData->parameters->$capaciteProp2) && !empty($blockData->parameters->$capaciteProp2)) {
                $tmpVar = $blockData->parameters->$capaciteProp2;
                $criterionCode = null;
                $modalityCodes = [];
                $nbCriteresCapacite = 0;

                if(isset($tmpVar->criterion) && isset($tmpVar->criterion->criterionCode)) {
                    $criterionCode = $tmpVar->criterion->criterionCode;
	                if(isset($tmpVar->modalities) && is_array($tmpVar->modalities) && count($tmpVar->modalities) > 0) {
                        foreach($tmpVar->modalities as $modality) {
                            $modalityCodes[] = $modality->modalityCode;
                        }
                    }
                }

                if($criterionCode != null && $capaciteProp2 === 'nomSalleCriterion') {
	                $capacitesCriterions[$capaciteProp] = [ 'criterionCode' => $criterionCode, 'modalityCode' => $modalityCodes ];
	                $hasNameDefined = true;
                } elseif($criterionCode != null && $capaciteProp2 !== 'nomSalleCriterion') {
	                $capacitesCriterions[$capaciteProp] = [ 'criterionCode' => $criterionCode, 'modalityCode' => $modalityCodes ];
	                $hasAtLEastOneCapaciteDefined = true;

                }
            }
        }
	    $nbCriteresCapacite = count($capacitesCriterions) - 1;
    }

    $nomsSalles = BridgeBlockService::filterModalities($fiche->modalities, $capacitesCriterions['nomSalle'] );

?>
<?php if ($hasNameDefined && $hasAtLEastOneCapaciteDefined && count($nomsSalles) >0 ): ?>

        <div class="bridge-table-capacites-salles-container">
            <table class="bridge-table-capacites-salles">
                <colgroup>
                    <col style="width:auto;"></col>
                    <?php for($i = 0; $i < $nbCriteresCapacite; $i++): ?>
                        <col style="width:50px;"></col>
                    <?php endfor; ?>
                </colgroup>
                <tr>
                    <th>Nom</th>
                    <?php foreach($capacitesCriterions as $key => $val): ?>
                        <?php if($key == 'nomSalle') continue; ?>
                        <th><?= BridgeUtils::bridgeInlineSvg(BridgeUtils::getBridgeImgUrl() . '/' . $key . '.svg', BridgeCmsAbstractLayer::__($capacitesLibelles[$key], 'pylot-bridge')) ?></th>
                    <?php endforeach; ?>
                </tr>

                <?php $capacitesArray = []; ?>
                <?php foreach($capacitesCriterions as $key => $val): ?>
                    <?php if($key == 'nomSalle') continue; ?>
                    <?php $tmp = BridgeBlockService::filterModalities($fiche->modalities, $val ); ?>
                    <?php $capacitesArray[$key] = $tmp ?>
                <?php endforeach; ?>

                <?php  // var_dump($nomsSalles); ?>
                <?php // var_dump($blockData->parameters->nomSalleCriterion); ?>
                <?php // var_dump($capacitesArray); ?>

                <?php for( $i = 0; $i < count($nomsSalles) ; $i++): ?>
                <tr>
                    <td class="bridge-salle-nom"><?= $nomsSalles[$i]->value ?></td>
			        <?php foreach($capacitesCriterions as $key => $val): ?>
                        <?php if($key == 'nomSalle') continue; ?>
                        <?php if(!isset($capacitesArray[$key]) || !isset($capacitesArray[$key][$i])): ?>
                            <td class="bridge-salle-capacite bridge-salle-capacite-vide">-</td>
                        <?php else: ?>
                            <td class="bridge-salle-capacite"><?= $capacitesArray[$key][$i]->value ?></td>
                        <?php endif; ?>

                    <?php endforeach; ?>
                </tr>
                <?php endfor; ?>

            </table>
        </div>
    <?php else: ?>
<?php  endif; ?>
<?php // } // fin dev DN ?>
