<?php
/**
 * Template d'affichage de composant carte de position dans une page fiche détaillée
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/gabarits
 *
 * @version 3.3
 *
 */



if(!empty($fiche->latitude) && !empty($fiche->longitude)): ?>

    <section class="uk-margin composant-carte-de-position">
        <div id="maps-carte-de-position" style="height:450px;" class="uk-width-1-1"></div>
    </section>

    <script type="text/javascript">
        // <!--
        // Gère le javascript de la carto
        bridgeDocumentReady(function($j)
        {
            window.markercmpt = 0;
            window.mapServiceCarteDePosition = new dncLeafletServices('maps-carte-de-position');
            window.mapServiceCarteDePosition.mapoptions = {
                zoom: '14', // Niveau de Zoom de départ
                centerlat: <?= $fiche->latitude; ?>, // Latitude du centre au départ
                centerlon: <?= $fiche->longitude; ?>, // Longitude du centre au départ
                maptype: 'MAPTYPE_OPENSTREETMAPS', // Type de vue : ROAD, SATTELITE, HYBRID, 3D
                gridSize: 0,
                maxZoom: 5,
                scrollWheelZoom: false
            };
            var mapdiv = document.getElementById("maps-carte-de-position");
            //abso();

            window.mapServiceCarteDePosition.defaultIconOptions =  {
                iconSize:     [<?= $bridgeParameters->marker_map_width ?>, <?= $bridgeParameters->marker_map_height ?>],
                iconAnchor:   [<?= round($bridgeParameters->marker_map_width/2) ?>, <?= round($bridgeParameters->marker_map_height/2) ?>],
                popupAnchor:  [0, -3]
            };
            window.mapServiceCarteDePosition.init();

            window.mapServiceCarteDePosition.switchToWordpress();
            window.mapServiceCarteDePosition.disabledMouseWheel();
            // On ajoute le point
            window.mapServiceCarteDePosition.addmarker ("1", <?= $fiche->latitude ?>, <?= $fiche->longitude ?>,"<?= $fiche->name; ?>",'<?= $bridgeParameters->marker_map ?>') ;


            <?php if($fiche->kml != ''): ?>
            window.mapServiceCarteDePosition.addkml('<?= $fiche->kml; ?>','1');
            <?php endif; ?>

            window.mapServiceCarteDePosition.centeronmarker("1","14");
            window.mapServiceCarteDePosition.fitboundstomarkers();

            UIkit.util.on('#tabs-sit > .composant-carte-de-position','beforeshow', function(){
                window.mapServiceCarteDePosition.centeronmarker("1","14");
                window.mapServiceCarteDePosition.reDraw();
                window.mapServiceCarteDePosition.fitboundstomarkers();
                //abso();
            });
        });

        jQuery(window).resize(function() {
            //abso();
        });

        function abso() {
            var sizeneg = (jQuery(window).width()-jQuery('#maps-carte-de-position').parents('.elementor-container').width()+100)/2;
            jQuery('#maps-carte-de-position').css({
                position: 'relative',
                width: jQuery(window).width(),
                //left: '50%',
                marginLeft: '-'+sizeneg+'px'
            });
        }
        // -->
    </script>
<?php endif; ?>
