<?php
/**
 * Template d'affichage de composant dates d'ouvertures/ de manifs en calendrier
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/gabarits
 *
 * @version 3.3
 *
 */

$horaires = $fiche->hours;
$tabAffichage = DateUtils::getFicheHoursAsArrayForDisplayAsCalendar($fiche, $bridgeParameters->lang);
$fin = '';

?>


<div class="datesheures composant-dates-calendrier bridge-calendar">
    <section class="main">
        <div class="custom-calendar-wrap">
            <div id="custom-inner" class="custom-inner">
                <div class="custom-header clearfix">
                    <nav>
                        <span id="custom-prev" class="custom-prev"><i class="fa fa-arrow-left"></i></span>
                        <span id="custom-next" class="custom-next"><i class="fa fa-arrow-right"></i></span>
                    </nav>
                    <h4 class="custom-calendar-title"><span id="custom-month" class="custom-month"></span> <span id="custom-year" class="custom-year"></span></h4>
                </div>
                <div id="calendar" class="fc-calendar-container"></div>
            </div>
        </div>
        <?php if($fin != ''): ?>
            <p>
                <strong><?= BridgeCmsAbstractLayer::__('A_NOTER'); ?> :</strong>
                <?= BridgeCmsAbstractLayer::__('TEXTE_TPS_AVANT'); ?> <strong><?php echo $fin; ?></strong> <?= BridgeCmsAbstractLayer::__('TEXTE_TPS_APRES'); ?>
            </p>
        <?php endif; ?>
    </section>


    <?php /*?> <div class="legende">
                	<div class="dispo"><?= BridgeCmsAbstractLayer::__('OUVERT'); ?></div>
                	<div class="indispo"><?= BridgeCmsAbstractLayer::__('FERMER'); ?></div>
                </div><?php */?>
    <script type="text/javascript">
        // <!--
        jQuery(function() {

            var dncdispo = {
                <?php $i=0; ?>
                <?php foreach($tabAffichage as $key => $ladispo): ?>
                    <?= ($i > 0)?',':''?>"<?= $ladispo['ladate'] ?>": {statut: <?=$ladispo['statut'] ?>, content:"<?= ($ladispo['statut'] == 1) ? BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_OUVERT', 'Ouvert', 'plugin-sit').' '.implode(', ',$ladispo['horaires']) : BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_FERME', 'Fermé', 'plugin-sit') ?>"}
                    <?php $i++; ?>
                <?php endforeach; ?>
            };

            var transEndEventNames = {
                    'WebkitTransition' : 'webkitTransitionEnd',
                    'MozTransition' : 'transitionend',
                    'OTransition' : 'oTransitionEnd',
                    'msTransition' : 'MSTransitionEnd',
                    'transition' : 'transitionend'
                },
                transEndEventName = transEndEventNames[ Modernizr.prefixed( 'transition' ) ],
                    $wrapper = jQuery( '#custom-inner' ),
                $calendar = jQuery( '#calendar' ),
                cal = $calendar.calendario( {
                    onDayClick : function( $el, $contentEl, dateProperties ) {
                        if( $contentEl.length > 0 ) {
                            showEvents( $contentEl, dateProperties );
                        }
                    },
                    weeks : [ '<?= BridgeCmsAbstractLayer::__('SUNDAY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('MONDAY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('TUESDAY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('WEDNESDAY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('THURSDAY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('FRIDAY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('SATURDAY','plugin-sit') ?>' ],
                    weekabbrs : [ '<?= BridgeCmsAbstractLayer::__('SU','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('MO','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('TU','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('WE','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('TH','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('FR','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('SA','plugin-sit') ?>' ],
                    months : [ '<?= BridgeCmsAbstractLayer::__('JANUARY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('FEBRUARY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('MARCH','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('APRIL','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('MAY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('JUNE','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('JULY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('AUGUST','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('SEPTEMBER','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('OCTOBER','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('NOVEMBER','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('DECEMBER','plugin-sit') ?>' ],
                    monthabbrs : [ '<?= BridgeCmsAbstractLayer::__('JAN','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('FEB','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('MAR','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('APR','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('MAY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('JUN','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('JUL','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('AUG','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('SEP','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('OCT','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('NOV','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('DEC','plugin-sit') ?>' ],
                    caldata : dncdispo,
                    displayWeekAbbr : true,
                    consult : '<?= BridgeCmsAbstractLayer::__('Fermé','plugin-sit') ?>',
                    fermé : '<?= BridgeCmsAbstractLayer::__('Fermé','plugin-sit') ?>',
                    complet : '<?= BridgeCmsAbstractLayer::__('Fermé','plugin-sit') ?>',
                    dispo : '<?= BridgeCmsAbstractLayer::__('Ouvert','plugin-sit') ?>'
                } ),
                $month = jQuery( '#custom-month' ).html( cal.getMonthName() ),
                $year = jQuery( '#custom-year' ).html( cal.getYear() );

            jQuery( '#custom-next' ).on( 'click', function() {
                cal.gotoNextMonth( updateMonthYear );
            } );
            jQuery( '#custom-prev' ).on( 'click', function() {
                cal.gotoPreviousMonth( updateMonthYear );
            } );

            function updateMonthYear() {
                $month.html( cal.getMonthName() );
                $year.html( cal.getYear() );
            }

            // just an example..
            function showEvents( $contentEl, dateProperties ) {
                hideEvents();
                var $events = jQuery( '<div id="custom-content-reveal" class="custom-content-reveal"><h4>' + dateProperties.monthname + ' ' + dateProperties.day + ', ' + dateProperties.year + '</h4></div>' ),
                $close = jQuery( '<span class="custom-content-close"></span>' ).on( 'click', hideEvents );
                $events.append( $contentEl.html() , $close ).insertAfter( $wrapper );
                setTimeout( function() {
                    $events.css( 'top', '0%' );
                }, 25 );
            }
            function hideEvents() {

                var $events = jQuery( '#custom-content-reveal' );
                if( $events.length > 0 ) {
                    $events.css( 'top', '100%' );
                    //Modernizr.csstransitions ? $events.on( transEndEventName, function() { jQuery( this ).remove(); } ) : $events.remove();
                }
            }

        });
        // -->
    </script>
</div>
