<?php
/**
 * Template d'affichage de composant dates d'ouvertures/ de manifs en tableau
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/gabarits
 *
 * @version 3.3.2
 *
 */

$horaires = $fiche->hours;
$tabAffichage = DateUtils::getFicheHoursAsArrayForDisplayAsCalendar($fiche, $bridgeParameters->lang);

$startDate = new \DateTime("last monday");
$startDateYmd = $startDate->format('Y-m-d');
$dates = array_keys($tabAffichage);
$curIdx = array_search($startDateYmd, $dates);

// print_r($tabAffichage);
$activeDate = new \DateTime();
$activeDateStr = $activeDate->format('Y-m-d');

$startDatedmY = $startDate->format('d/m/Y');
$endDate = new \DateTime("next sunday");
$endDatedmY = $endDate->format('d/m/Y');

$locale = BridgeUtils::getLanguageLocale();
$pickerLanguage = $locale;
if(strlen($pickerLanguage) == 2) {
    $pickerLanguage = strtolower($pickerLanguage) . '-' . strtoupper($pickerLanguage);
}

if (isset($horaires) && count($horaires) > 0) : ?>

    <script type="text/javascript">
        // <!--
        jQuery(document).ready(function() {

            var bridgeDatesFiche = {
                <?php $i=0; ?>
                <?php foreach($tabAffichage as $key => $ladispo): ?>
                <?php $tabkey = substr($ladispo['ladate'], 6,4) . '-' . substr($ladispo['ladate'], 0,2) . '-' .substr($ladispo['ladate'], 3,2); ?>
                <?= ($i > 0)?',':''?>"<?= $tabkey ?>": {statut: <?=$ladispo['statut'] ?>, content:"<?= ($ladispo['statut'] == 1) ? implode(BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_ET', ' et ', 'plugin-sit'),$ladispo['horaires']) : BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_FERME', 'Fermé', 'plugin-sit') ?>"}
            <?php $i++; ?>
            <?php endforeach; ?>
            };

            window.bridge_hours_datepicker = jQuery('#bridge-hours-table-start-date').datepicker({
                language: '<?= $pickerLanguage ?>',
                format: 'yyyy-mm-dd',
                weekStart: 1,
                zIndex: 1000000,
                autoHide: true,
                // container: jQuery(this).parent(),
                trigger: '.edit-horaires',
                // pick: bridge_hours_table_changeDate
            });

            window.bridge_hours_datepicker.on('pick.datepicker', function(e) {
                // var dateUs = jQuery(window.bridge_hours_datepicker).datepicker('getDate', true);
                var selectedDate = e.date;
                // On se met sur Greenwich pour éviter les déclages en ISO
                selectedDate.setUTCHours(0);
                var selectedDateUs = selectedDate.toISOString().substr(0,10);
                var lastMonday = new Date(selectedDate);

                // On descend au Lundi précédent la date sélectionnée
                lastMonday.setDate(lastMonday.getDate() - ((lastMonday.getDay() + 6) % 7));

                var curDay = new Date(lastMonday.getTime());
                var curDayUs = curDay.toISOString().substr(0,10);
                var dow = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'];
                var tdText = '';

                for(var i=0 ; i < 7 ; i++ ) {
                    tdText = bridgeDatesFiche[curDayUs].content;
                    if(selectedDateUs === curDayUs && bridgeDatesFiche[curDayUs].statut === 1) {
                        tdText += ' <strong><i class="fa fa-check"></i> <?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_OUVERT', 'Ouvert', 'plugin-sit')?></strong>';
                    }
                    jQuery('#bridge-hours-table-' + dow[i]).html(tdText);

                    curDay.setDate(curDay.getDate() + 1);
                    curDayUs = curDay.toISOString().substr(0,10);
                }
                // On recale la date de fin
                curDay.setDate(curDay.getDate() - 1);
                jQuery('#bridge-hours-display-start-date').html(lastMonday.toLocaleDateString("fr"));
                jQuery('#bridge-hours-display-end-date').html(curDay.toLocaleDateString("fr"));
            });
        });
        // -->
    </script>
    <section class="horaires composant-dates-tableau">

        <div class="uk-flex uk-flex-between">

            <h3><span class="dates"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_DU', 'Du', 'plugin-sit')?> <span id="bridge-hours-display-start-date"><?= $startDatedmY ?></span> <?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_AU', 'Au', 'plugin-sit')?> <span id="bridge-hours-display-end-date"><?= $endDatedmY ?></span></span></h3>
            <div id="bridge-hours-display-change-date">

                <button class="uk-link edit-horaires"><i class="fa-solid fa-calendar"></i> <?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_CHOOSE_DATE', 'Choisir la date', 'plugin-sit')?></button>
                <div id="bridge-hours-table-start-date" style="visibility:hidden;width:1px; height:1px; overflow:hidden;">&nbsp;</div>
            </div>
        </div>
        <div class="horaires">
            <table id="bridge-hours-table" class="uk-table uk-table-divider" border="0">
                <tr>
                    <th scope="row"><?= BridgeCmsAbstractLayer::__('Lundi','plugin-sit') ?></th>
                    <td id="bridge-hours-table-monday">
                        <?= implode(BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_ET', ' et ', 'plugin-sit'), $tabAffichage[$dates[$curIdx]]['horaires']) ?>
                        <?= ($tabAffichage[$dates[$curIdx]]['statut'] == 0)?BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_FERME', 'Fermé', 'plugin-sit'):'' ?>
                        <?= ($activeDateStr == $dates[$curIdx] && $tabAffichage[$dates[$curIdx]]['statut'] == 1)?'<strong><i class="fa fa-check"></i> ' . BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_OUVERT', 'Ouvert', 'plugin-sit') . '</strong>':'' ?>
                        <?php $curIdx++; ?>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?= BridgeCmsAbstractLayer::__('Mardi','plugin-sit') ?></th>
                    <td id="bridge-hours-table-tuesday">
                        <?= implode(BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_ET', ' et ', 'plugin-sit'), $tabAffichage[$dates[$curIdx]]['horaires']) ?>
                        <?= ($tabAffichage[$dates[$curIdx]]['statut'] == 0)?BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_FERME', 'Fermé', 'plugin-sit'):'' ?>
                        <?= ($activeDateStr == $dates[$curIdx] && $tabAffichage[$dates[$curIdx]]['statut'] == 1)?'<strong><i class="fa fa-check"></i> ' . BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_OUVERT', 'Ouvert', 'plugin-sit') . '</strong>':'' ?>
                        <?php $curIdx++; ?>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?= BridgeCmsAbstractLayer::__('Mercredi','plugin-sit') ?></th>
                    <td id="bridge-hours-table-wednesday">
                        <?= implode(BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_ET', ' et ', 'plugin-sit'), $tabAffichage[$dates[$curIdx]]['horaires']) ?>
                        <?= ($tabAffichage[$dates[$curIdx]]['statut'] == 0)?BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_FERME', 'Fermé', 'plugin-sit'):'' ?>
                        <?= ($activeDateStr == $dates[$curIdx] && $tabAffichage[$dates[$curIdx]]['statut'] == 1)?'<strong><i class="fa fa-check"></i> ' . BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_OUVERT', 'Ouvert', 'plugin-sit') . '</strong>':'' ?>
                        <?php $curIdx++; ?>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?= BridgeCmsAbstractLayer::__('Jeudi','plugin-sit') ?></th>
                    <td id="bridge-hours-table-thursday">
                        <?= implode(BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_ET', ' et ', 'plugin-sit'), $tabAffichage[$dates[$curIdx]]['horaires']) ?>
                        <?= ($tabAffichage[$dates[$curIdx]]['statut'] == 0)?BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_FERME', 'Fermé', 'plugin-sit'):'' ?>
                        <?= ($activeDateStr == $dates[$curIdx] && $tabAffichage[$dates[$curIdx]]['statut'] == 1)?'<strong><i class="fa fa-check"></i> ' . BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_OUVERT', 'Ouvert', 'plugin-sit') . '</strong>':'' ?>
                        <?php $curIdx++; ?>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?= BridgeCmsAbstractLayer::__('Vendredi','plugin-sit') ?></th>
                    <td id="bridge-hours-table-friday">
                        <?= implode(BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_ET', ' et ', 'plugin-sit'), $tabAffichage[$dates[$curIdx]]['horaires']) ?>
                        <?= ($tabAffichage[$dates[$curIdx]]['statut'] == 0)?BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_FERME', 'Fermé', 'plugin-sit'):'' ?>
                        <?= ($activeDateStr == $dates[$curIdx] && $tabAffichage[$dates[$curIdx]]['statut'] == 1)?'<strong><i class="fa fa-check"></i> ' . BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_OUVERT', 'Ouvert', 'plugin-sit') . '</strong>':'' ?>
                        <?php $curIdx++; ?>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?= BridgeCmsAbstractLayer::__('Samedi','plugin-sit') ?></th>
                    <td id="bridge-hours-table-saturday">
                        <?= implode(BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_ET', ' et ', 'plugin-sit'), $tabAffichage[$dates[$curIdx]]['horaires']) ?>
                        <?= ($tabAffichage[$dates[$curIdx]]['statut'] == 0)?BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_FERME', 'Fermé', 'plugin-sit'):'' ?>
                        <?= ($activeDateStr == $dates[$curIdx] && $tabAffichage[$dates[$curIdx]]['statut'] == 1)?'<strong><i class="fa fa-check"></i> ' . BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_OUVERT', 'Ouvert', 'plugin-sit') . '</strong>':'' ?>
                        <?php $curIdx++; ?>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?= BridgeCmsAbstractLayer::__('Dimanche','plugin-sit') ?></th>
                    <td id="bridge-hours-table-sunday">
                        <?= implode(BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_ET', ' et ', 'plugin-sit'), $tabAffichage[$dates[$curIdx]]['horaires']) ?>
                        <?= ($tabAffichage[$dates[$curIdx]]['statut'] == 0)?BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_FERME', 'Fermé', 'plugin-sit'):'' ?>
                        <?= ($activeDateStr == $dates[$curIdx] && $tabAffichage[$dates[$curIdx]]['statut'] == 1)?'<strong><i class="fa fa-check"></i> ' . BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_OUVERT', 'Ouvert', 'plugin-sit') . '</strong>':'' ?>
                        <?php $curIdx++; ?>
                    </td>
                </tr>
            </table>
        </div>
    </section>


<?php endif; ?>
