<?php
/**
 * Template d'affichage de composant dates d'ouvertures/ de manifs en tableau
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/gabarits
 *
 * @version 3.3.2
 *
 */

$dateTexteHoraires = $fiche->hours;

$dateTexteOptionsAffDates = array(
  'afficher_du' => true,
  'afficher_au' => true,
  'afficher_le' => false,
  'en_clair' => false,
  'afficher_annee_debut' => true,
    'afficher_annee_fin' => true
);

$periodesTraitees = array();

if (is_array($dateTexteHoraires) && count($dateTexteHoraires) > 0) : ?>
    <section class="horaires composant-dates-texte">
    <?php foreach ($dateTexteHoraires as $dateTexteHoraire): ?>
        <?php
            // On récupère les données d'horaires déjà moulinés et recollés
            $dateTexteOptions = array();
            $dateTexteOptions['dateFrom'] = substr($dateTexteHoraire->dateFrom->date, 0, 10);
            $dateTexteOptions['dateTo'] = substr($dateTexteHoraire->dateTo->date, 0, 10);
            $cleDateTexte = $dateTexteOptions['dateFrom'] . '-' . $dateTexteOptions['dateTo'];

            if(in_array($cleDateTexte, $periodesTraitees)) continue;
            $periodesTraitees[] = $cleDateTexte;

            $dateTexteOptions['one_strict_period'] = true;
            $dateTexteRawData = DateUtils::prepareHoursForDisplay($fiche, $bridgeParameters->lang, $dateTexteOptions);
            $dateTexteDateFrom = date_create_from_format('Y-m-d', $dateTexteOptions['dateFrom']);
            $dateTexteDateTo = date_create_from_format('Y-m-d', $dateTexteOptions['dateTo']);
            $hourFromTxt = '';
            $hourToTxt = '';
            if(isset($dateTexteHoraire->hourFrom) && is_object($dateTexteHoraire->hourFrom) && isset($dateTexteHoraire->hourFrom->date) && !empty($dateTexteHoraire->hourFrom->date)) {
                $hourFrom = date_create_from_format('Y-m-d H:i:s', substr((string) $dateTexteHoraire->hourFrom->date,0 , 19));
                $hourFromTxt = $hourFrom->format('H:i');
            }
            if(isset($dateTexteHoraire->hourTo) && is_object($dateTexteHoraire->hourTo) && isset($dateTexteHoraire->hourTo->date) && !empty($dateTexteHoraire->hourTo->date)) {
                $hourTo = date_create_from_format('Y-m-d H:i:s', substr((string) $dateTexteHoraire->hourTo->date,0 , 19));
                $hourToTxt = $hourTo->format('H:i');
            }
            $dateTexteOptions['dateFrom'] = substr($dateTexteHoraire->dateFrom->date, 0, 10);
            $dateTexteOptions['dateTo'] = substr($dateTexteHoraire->dateTo->date, 0, 10);

            ?>
            <div class="bridge_horaire">
                <div class="uk-h4 bridge_periode">
                    <?= DateUtils::affiche_intervalle_dates($dateTexteDateFrom->format('d/m/Y'), $dateTexteDateTo->format('d/m/Y'),$bridgeParameters->lang, $dateTexteOptionsAffDates ) ?>
                    <?php if ($dateTexteDateFrom == $dateTexteDateTo): ?>
                        <?php if($hourFromTxt != '' && $hourFromTxt == $hourToTxt): ?>
                            <span class="bridge_hour"><?= $hourFromTxt ?></span>
                        <?php elseif($hourFromTxt != '' && $hourToTxt != '' && $hourFromTxt != $hourToTxt): ?>
                            <span class="bridge_hour"><?= $hourFromTxt ?>-<?= $hourToTxt ?></span>
	                    <?php else: ?>
                            <span class="bridge_hour"><?= $hourFromTxt ?><?= $hourToTxt ?></span>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
                <?php if($dateTexteDateFrom != $dateTexteDateTo && isset($dateTexteRawData['jours']) && count($dateTexteRawData['jours']) > 0): ?>
                    <div class="bridge_horaires">
                        <?php foreach($dateTexteRawData['jours'] as $keyjour => $heures): ?>
                            <?php if (is_array($heures) && count($heures) > 0 && !empty($heures[0])): ?>
                                <?php $heures = array_filter($heures); // On enlmeve les valeurs vides ?>
                                <?php if (is_array($heures) && count($heures) > 0): ?>
                                    <span class="bridge_jour"><?= BridgeCmsAbstractLayer::__($keyjour, 'plugin-sit') ?> : <?= implode(' / ', $heures) ?></span><br/>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>


    <?php endforeach; ?>
    </section>
<?php endif; ?>
