<?php
/**
 * Template d'affichage de barre de boutons de téléchargement de documents
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/gabarits
 *
 * @version 3.3.15
 *
 */

$documents = BridgeblockService::extractPhotosFromBlock($blockData);
?>

<?php if(count($documents) > 0): ?>
    <?php $cmptdoc = 0 ; ?>
    <div class="bridge-documents">
        <?php if((isset($item) && is_object($item) && empty($item->title)) && (isset($onglet) && is_object($onglet) && empty($onglet->title))): ?>
            <h3 class="uk-text-center"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_TELECHARGEMENTS', 'Téléchargements','plugin-sit'); ?></h3>
        <?php endif; ?>
        <div class="documents_inner uk-grid-small uk-grid-match">
            <?php foreach($documents as $doc): ?>
                <div class="bridge-document uk-margin-top">
                    <?php $cmptdoc++; ?>
                    <?php if(!empty($doc->url)): ?>
                    <a href="<?= $doc->url ?>" class="download-link uk-button uk-button-default" target="_blank" title="<?= BridgeCmsAbstractLayer::esc_attr(BridgeCmsAbstractLayer::__('Document ' . $cmptdoc,'plugin-sit')) ?>"><?= (!empty($doc->caption) && $doc->caption!=' ') ? $doc->caption : BridgeCmsAbstractLayer::__('Document ' . $cmptdoc,'plugin-sit') ?></a>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>
